<?php
class WPBakeryShortCode_gg_featured_image extends WPBakeryShortCode {

   public function __construct() {  
         add_shortcode('featured_image', array($this, 'gg_featured_image'));  
   }

   public function gg_featured_image( $atts, $content = null ) { 

         $output = $featured_link_open = $featured_link_close = $img_style_class = $featured_box_style_cls = $featured_title = $image = '';
         extract(shortcode_atts(array(
             'featured_title'           => '',
             'featured_desc'            => '',
             'featured_link'            => '',
             'featured_box_style'       => 'normal',
             'featured_box_text_align'  => 'left',
             'image'                    => $image,
             'img_size'                 => 'fullsize',
             'img_style'                => 'default',
             'customsize_width'         => '',
             'customsize_height'        => '',
             'el_class'                 => '',
             'css_animation'            => ''
         ), $atts));

         $img_id = preg_replace('/[^\d]/', '', $image);

         if ($img_id > 0) {
            $attachment_url = wp_get_attachment_url($img_id , 'full');
            $alt_text = get_post_meta($img_id, '_wp_attachment_image_alt', true);
            if ($img_size !== 'fullsize') {
                $thumbnail = ' <img class="wp-post-image '.$img_style.'" src="'.gg_aq_resize( $img_id, $customsize_width, $customsize_height, true, true ).'" alt="'.$alt_text.'" /> ';
            } else {
                $thumbnail = ' <img class="wp-post-image '.$img_style.'" src="'.$attachment_url.'" /> ';          
            }
        }

         $css_class = $this->getCSSAnimation($css_animation);
         $css_class .= ' text-align-'.$featured_box_text_align;

         if ($featured_box_style == 'overlay') {
          $featured_box_style_cls .= ' sadie';
         } else {
          $featured_box_style_cls .= '';
         }

         

        $url = vc_build_link( $featured_link );
        
          if ( strlen( $featured_link ) > 0 && strlen( $url['url'] ) > 0 ) {
            $featured_link_open = '<a href="' . esc_attr( $url['url'] ) . '" title="' . esc_attr( $url['title'] ) . '" target="' . ( strlen( $url['target'] ) > 0 ? esc_attr( $url['target'] ) : '_self' ) . '">';
            $featured_link_close = '</a>';
            $featured_title_html = $featured_link_open.$featured_title.$featured_link_close;
          } else {
            $featured_title_html = $featured_title;
          }
         
         $output = "\n\t".'<div class="featured-image-box '.$css_class.'">';

         $output .= "\n\t\t".'<figure class="'.$featured_box_style_cls.' '.$img_style.'">';
         $output .= "\n\t\t\t".$featured_link_open.$thumbnail.$featured_link_close;
         $output .= "\n\t\t".'<figcaption>';

         if ($featured_box_style == 'overlay') {
         $output .= "\n\t\t\t".$featured_link_open.$featured_link_close; 
         $output .= "\n\t\t\t".'<h4>'.$featured_title.'</h4>';
         } else {
         $output .= "\n\t\t\t".'<h4>'.$featured_title_html.'</h4>'; 
         }

         $output .= "\n\t\t\t".'<p>'.$featured_desc.'</p>';
         $output .= "\n\t\t".'</figcaption>';
         $output .= "\n\t\t".'</figure>';
         
         $output .= "\n\t".'</div> ';

         return $output;
         
   }
}

$WPBakeryShortCode_gg_featured_image = new WPBakeryShortCode_gg_featured_image();  

vc_map( array(
   "name" => __("Featured image box","okthemes"),
   "description" => __('Image box with title and description.', 'okthemes'),
   "base" => "featured_image",
   "class" => "clear_vc_style",
   "icon" => "icon-wpb-gg_vc_featured_image_box",
   'admin_enqueue_css' => array(get_template_directory_uri().'/lib/visualcomposer/styles.css'),
   'admin_enqueue_js' => array(get_template_directory_uri().'/lib/visualcomposer/custom-vc.js'),
   "category" => __('OKThemes','okthemes'),
   "params" => array(
      array(
            "type" => "dropdown",
            "heading" => __("Box style", "js_composer"),
            "param_name" => "featured_box_style",
            "value" => array(__("Normal (text under the image)", "js_composer") => "normal", __("Overlay (text on the image)", "js_composer") => "overlay"),
            "description" => __("Choose the image size", "js_composer")
      ),
      array(
            "type" => "dropdown",
            "heading" => __("Box text align", "js_composer"),
            "param_name" => "featured_box_text_align",
            "value" => array(__("Left", "js_composer") => "left", __("Right", "js_composer") => "right", __("Center", "js_composer") => "center" ),
            "description" => __("Choose the image size", "js_composer")
      ),
      array(
         "type" => "textfield",
         "heading" => __("Title","okthemes"),
         "param_name" => "featured_title",
         "admin_label" => true,
         "description" => __("Insert title here","okthemes")
      ),
      array(
         "type" => "textarea",
         "heading" => __("Description","okthemes"),
         "param_name" => "featured_desc",
         "description" => __("Insert short description here","okthemes")
      ),
      array(
        "type" => "vc_link",
        "heading" => __("URL (Link)", "okthemes"),
        "param_name" => "featured_link",
        "description" => __("Insert the link.", "okthemes"),
        "dependency" => Array('element' => "featured_title", 'not_empty' => true)
      ),
      array(
         "type" => "attach_image",
         "heading" => __("Featured image", "okthemes"),
         "param_name" => "image",
         "value" => "",
         "description" => __("Select image from media library.", "okthemes")
      ),
      //Image size
      array(
            "type" => "dropdown",
            "heading" => __("Image size", "js_composer"),
            "param_name" => "img_size",
            "value" => array(__("Full size", "js_composer") => "fullsize", __("Custom size", "js_composer") => "customsize"),
            "description" => __("Choose the image size", "js_composer")
      ),
      array(
          "type" => "dropdown",
          "heading" => __("Image style", "js_composer"),
          "param_name" => "img_style",
          "value" => $img_style_arr,
          "std" => "default",
          "description" => __("Choose the image style", "js_composer")
      ),
      array(
            "type" => "textfield",
            "heading" => __("Custom size - width", "js_composer"),
            "param_name" => "customsize_width",
            "description" => __("Insert the width of the image", "js_composer"),
            "dependency" => Array('element' => "img_size", 'value' => array('customsize'))
      ),
      array(
            "type" => "textfield",
            "heading" => __("Custom size - height", "js_composer"),
            "param_name" => "customsize_height",
            "description" => __("Insert the height of the image", "js_composer"),
            "dependency" => Array('element' => "img_size", 'value' => array('customsize'))
      ),
      $add_css_animation,
   ),
   'js_view'  => 'vouxVcFeaturedImageView',
) );

?>