<?php
//Remove the horizontal/vertical option
vc_remove_param ('vc_images_carousel', 'mode' );
vc_remove_param ('vc_images_carousel', 'img_size' );
vc_remove_param ('vc_images_carousel', 'speed' );
vc_remove_param ('vc_images_carousel', 'wrap' );

//Remove the horizontal/vertical option
vc_remove_param ('vc_images_carousel', 'partial_view' );

//Image style
vc_add_param("vc_images_carousel", array(
      "type" => "dropdown",
      "heading" => __("Image style", "js_composer"),
      "param_name" => "img_style",
      "value" => $img_style_arr,
      "std" => "default",
      "description" => __("Choose the image style", "js_composer")
  )
);

//Image size
vc_add_param("vc_images_carousel", array(
      "type" => "dropdown",
      "heading" => __("Image size", "js_composer"),
      "param_name" => "img_size",
      "value" => array(__("Full size", "js_composer") => "fullsize", __("Custom size", "js_composer") => "customsize"),
      "description" => __("Choose the image size", "js_composer")
  )
);
vc_add_param("vc_images_carousel", array(
      "type" => "textfield",
      "heading" => __("Custom size - width", "js_composer"),
      "param_name" => "customsize_width",
      "description" => __("Insert the width of the image", "js_composer"),
      "dependency" => Array('element' => "img_size", 'value' => array('customsize'))
  )
);
vc_add_param("vc_images_carousel", array(
      "type" => "textfield",
      "heading" => __("Custom size - height", "js_composer"),
      "param_name" => "customsize_height",
      "description" => __("Insert the height of the image", "js_composer"),
      "dependency" => Array('element' => "img_size", 'value' => array('customsize'))
  )
);


//Modify slides per view with select box
vc_add_param("vc_images_carousel", array(
      "type" => "dropdown",
      "heading" => __("Slides per view", "js_composer"),
      "param_name" => "slides_per_view",
      "value" => array(1, 2, 3, 4, 5, 6, 7, 8, 9, 10),
      "description" => __("Set numbers of slides you want to display at the same time on slider's container for carousel mode.", "js_composer")
  )
);


vc_add_param("vc_images_carousel", array(
  "type" => "checkbox",
  "heading" => __("Partially show the carousel hidden items?","okthemes"),
  "value" => array(__("Show the carousel hidden item","okthemes") => "show_hidden_items" ),
  "param_name" => "hidden_items",
  "description" => __("Shows the carousel hidden items with opacity .5","okthemes")
));

vc_add_param("vc_images_carousel", array(
  "type" => "checkbox",
  "heading" => __("Scroll slides with mousewheel?","okthemes"),
  "value" => array(__("Yes, please","okthemes") => "true" ),
  "param_name" => "mousewheel",
  "description" => __("Scroll the slides with the help of mousewheel","okthemes")
));

vc_add_param("vc_images_carousel", $add_css_animation);

?>