<?php
class WPBakeryShortCode_gg_products_grid extends WPBakeryShortCode {

   public function __construct() {  
         add_shortcode('products_grid', array($this, 'gg_products_grid'));  
   }

   public function gg_products_grid( $atts, $content = null ) { 

         $output = $carousel_mousewheel_html = $hidden_items = $carousel_data = $carousel_data_html = $product_featured = $product_onsale = $product_best_seller = $link_html = $image = $el_class = $isotope_item = $is_carousel = $carousel_data = $is_unlimited = '';
         extract(shortcode_atts(array(
            'products_grid_col_select' => '',
            'products_grid_no_posts'   => '',
            'products_grid_terms'      => '',
            'posts_in'                 => '',
            'posts_not_in'             => '',
            'orderby'                  => '',
            'order'                    => '',
            'grid_layout_mode'         => 'fitRows',
            'grid_layout_style'        => 'gap',
            'el_class'                 => '',
            'css_animation'            => '',
            'best_sellers_tab'         => '',
            'featured_tab'             => '',
            'sale_tab'                 => '',
            'hidden_items'             => '',
            'carousel_nav'             => '',
            'carousel_pag'             => '',
            'carousel_autoplay'        => '',
            'products_grid_pagination' => '',
            'extend_filter_borders'    => '', 
            'mousewheel'               => '',
         ), $atts));

        

        //Defaults
        global $gg_is_vc;

        //Apply columns class based on column selection 
        switch ($products_grid_col_select) {
          case "2":
            $products_grid_col_class = 'col-xs-12 col-sm-6 col-md-6';
            break;
          case "3":
            $products_grid_col_class = 'col-xs-12 col-sm-6 col-md-4';
            break;
          case "4":
            $products_grid_col_class = 'col-xs-12 col-sm-6 col-md-3';
            break;
        }

        if ($products_grid_no_posts == '') {
          $products_grid_no_posts = '-1';  
        }

        //Animation
        $css_class = $this->getCSSAnimation($css_animation);
        //Extra class
        $css_class .= $this->getExtraClass( $el_class );

        if ( $grid_layout_mode == 'carousel' ) {

          //Load carousel
          wp_enqueue_script( 'slickcarousel' );

          //Load mousewheel
          if ($mousewheel == 'true') {
              wp_enqueue_script( 'mousewheel' );
              $carousel_mousewheel_html = ' data-mousewheel="'.$mousewheel.'"';
          }

          $isotope_item = '';
          $is_carousel = 'gg-slick-carousel';
          $convert_ul = 'div';
          $convert_li = 'div';
          $products_grid_col_class ='';
          $products_grid_pagination = false;
          $data_pagination = 'none';

          $carousel_data .= ' "slidesToShow": '.$products_grid_col_select.', ';
          $carousel_data .= ' "arrows": '.($carousel_nav == 'yes' ? 'true' : 'false').', ';
          $carousel_data .= ' "dots": '.($carousel_pag == 'yes' ? 'true' : 'false').', ';
          $carousel_data .= ' "autoplay": '.($carousel_autoplay == 'yes' ? 'true' : 'false').', ';
          $carousel_data .= ' "infinite": true, ';
          $carousel_data .= ' "slidesToScroll": 1, ';
          if (is_rtl()) {
            $carousel_data .= ' "rtl": true, ';
          }
          $carousel_data .= ' "responsive": [{"breakpoint": 600, "settings": {"slidesToShow": 2, "slidesToScroll": 1}}, {"breakpoint": 480, "settings": {"slidesToShow": 1, "slidesToScroll": 1}}] ';

          $carousel_data_html .= ' '.$carousel_mousewheel_html.' data-slick=\'{ '.$carousel_data.' }\' ';

        } else {
          $isotope_item = ' isotope-item';
          $is_carousel = '';
          $convert_ul = 'ul';
          $convert_li = 'li';
          $data_pagination = 'ajax_load';

          wp_enqueue_script( 'gg-isotope' );
          wp_enqueue_script( 'infinitescroll' );
          wp_enqueue_script( 'manual-trigger' );

           
        }

        //Start the insanity
        $output .= "\n\t".'<div class="'.$css_class.' woocommerce">';
        $output .= "\n\t".'<div class="gg_posts_grid">';

        //Grid filter
        if ($extend_filter_borders == 'yes') {
          $output .= "\n\t\t\t\t".'<div class="gg_filter_extended_container">';
        }
               
        $output .= "\n\t\t\t\t".'<ul class="gg_filter '.$is_carousel.'">';
        $output .= "\n\t\t\t\t\t".'<li class="active"><a href="#" data-filter="*">'.__("All", "okthemes").'</a></li>';
        
        if ($best_sellers_tab == 'use_best_sellers_tab') {
          $output .= "\n\t\t\t\t\t".'<li><a data-filter=".grid-specials-best-seller">'.__("Best sellers", "okthemes").'</a></li>';
        }

        if ($featured_tab == 'use_featured_tab') {
          $output .= "\n\t\t\t\t\t".'<li><a data-filter=".grid-specials-featured">'.__("Featured", "okthemes").'</a></li>';
        }

        $filter_terms = get_terms( 'product_cat', array(
          'slug' => explode(",",$products_grid_terms)
        ) );

        foreach ( $filter_terms as $term ) {
          $output .= "\n\t\t\t\t\t".'<li><a data-filter=".grid-cat-'.$term->slug.'">' . $term->name . ' </a></li>';
        }

        if ($sale_tab == 'use_sale_tab') {
          $output .= "\n\t\t\t\t\t".'<li><a data-filter=".grid-specials-sale">'.__("Sale", "okthemes").'</a></li>';
        }

        $output .= "\n\t\t\t\t".'</ul>';

        if ($extend_filter_borders == 'yes') {
          $output .= "\n\t\t\t\t".'</div>';
        }
        

        $paged = 1;
        if(get_query_var('paged')) {
          $paged = get_query_var('paged');
        } elseif(get_query_var('page')) {
          $paged = get_query_var('page');
        }
       
        $args = array (
            'post_type'              => 'product',
            'post_status'            => 'publish',
            'posts_per_page'         => $products_grid_no_posts,
            'orderby'                => $orderby,
            'order'                  => $order,
            'ignore_sticky_posts'    => true,
            'paged'                  => $paged,
        );
        
        if (($products_grid_terms != '')) {
            $args['tax_query'] = array(
              array(
                'taxonomy' => 'product_cat',
                'field' => 'slug',
                'include_children' => false,
                'terms' => explode(",",$products_grid_terms),
              ),
            );
        }

        $not_in = array();
        if ( $posts_not_in != '' ) {
          $posts_not_in = str_ireplace(" ", "", $posts_not_in);
          $not_in = explode(",", $posts_not_in);
        }

        //exclude current post from query
        if ( $posts_in == '' ) {
            global $post;
            array_push($not_in, $post->ID);
        } else if ( $posts_in != '' ) {
            $posts_in = str_ireplace(" ", "", $posts_in);
            $args['post__in'] = explode(",", $posts_in);
        }

        if ( $posts_in == '' || $posts_not_in != '' ) {
            $args['post__not_in'] = $not_in;
        }

        // The Query
        $wc_products_query = new WP_Query( $args );

        // The Loop
        if ( $wc_products_query->have_posts() ) {

        $output .= "\n\t".'<'.$convert_ul.' '.$carousel_data_html.' class="el-grid products row '.$is_carousel.' '.$hidden_items.'" data-layout-mode="'.$grid_layout_mode.'" data-pagination="'.$data_pagination.'">';

        while ( $wc_products_query->have_posts() ) : $wc_products_query->the_post();

        if ($featured_tab == 'use_featured_tab') {
          $product_featured = get_post_meta( $wc_products_query->post->ID,'_featured', true);
        } 

        if ($sale_tab == 'use_sale_tab') {
          $product_onsale = get_post_meta( $wc_products_query->post->ID,'_sale_price', true);
        }

        if ($best_sellers_tab == 'use_best_sellers_tab') {
          $product_best_seller = get_post_meta( $wc_products_query->post->ID,'total_sales', true);
        }

         $output .= "\n\t".'<'.$convert_li.' class="'.$isotope_item.' product '.( $product_onsale != '' ? ' grid-specials-sale' : '' ).' '.( $product_featured == 'yes' ? ' grid-specials-featured' : '' ).' '.( $product_best_seller != '0' ? ' grid-specials-best-seller' : '' ).' '.$products_grid_col_class.' '.gg_tax_terms_slug('product_cat').' ">';


         ob_start(); 
         wc_get_template_part( 'content', 'product-vc' );
         $output .= "\n\t".ob_get_contents();
         ob_end_clean();

         $output .= "\n\t".'</'.$convert_li.'>';
         
         endwhile; 
         wp_reset_postdata();
         
         $output .= "\n\t".'</'.$convert_ul.'>';

         } else {
         
         $output .= "\n\t".'<p>No posts found</p>';
         
         }

        if ( $products_grid_pagination ) {
          $output .= "\n\t".'<div class="load-more-anim"></div>';
          $output .= "\n\t".'<div class="pagination-load-more">';
          $output .= "\n\t\t".'<span class="pagination-span">';
          $output .= "\n\t\t".get_next_posts_link('Load more posts', $wc_products_query->max_num_pages);
          $output .= "\n\t\t".'</span>';
          $output .= "\n\t".'</div>';
        }

        $output .= "\n\t".'</div>';
        $output .= "\n\t".'</div>';

         return $output;
   }
}

$WPBakeryShortCode_gg_products_grid = new WPBakeryShortCode_gg_products_grid();

function productCategoryCategoryAutocompleteSuggester( $query, $slug = false ) {
    global $wpdb;
    $cat_id = (int) $query;
    $query = trim( $query );
    $post_meta_infos = $wpdb->get_results(
      $wpdb->prepare( "SELECT a.term_id AS id, b.name as name, b.slug AS slug
            FROM {$wpdb->term_taxonomy} AS a
            INNER JOIN {$wpdb->terms} AS b ON b.term_id = a.term_id
            WHERE a.taxonomy = 'product_cat' AND (a.term_id = '%d' OR b.slug LIKE '%%%s%%' OR b.name LIKE '%%%s%%' )",
        $cat_id > 0 ? $cat_id : - 1, stripslashes( $query ), stripslashes( $query ) ), ARRAY_A );

    $result = array();
    if ( is_array( $post_meta_infos ) && !empty( $post_meta_infos ) ) {
      foreach ( $post_meta_infos as $value ) {
        $data = array();
        $data['value'] = $slug ? $value['slug'] : $value['id'];
        $data['label'] = __( 'Id', 'js_composer' ) . ': ' .
                         $value['id'] .
                         ( ( strlen( $value['name'] ) > 0 ) ? ' - ' . __( 'Name', 'js_composer' ) . ': ' .
                                                              $value['name'] : '' ) .
                         ( ( strlen( $value['slug'] ) > 0 ) ? ' - ' . __( 'Slug', 'js_composer' ) . ': ' .
                                                              $value['slug'] : '' );
        $result[] = $data;
      }
    }

    return $result;
}

function productCategoryCategoryAutocompleteSuggesterBySlug( $query ) {
    $result = productCategoryCategoryAutocompleteSuggester( $query, true );

    return $result;
}

function productCategoryCategoryRenderByIdExact( $query ) {
    global $wpdb;
    $query = $query['value'];
    $cat_id = (int) $query;
    $term = get_term( $cat_id, 'product_cat' );

    return productCategoryTermOutput( $term );
}

function productCategoryCategoryRenderBySlugExact( $query ) {
    global $wpdb;
    $query = $query['value'];
    $query = trim( $query );
    $term = get_term_by( 'slug', $query, 'product_cat' );

    return productCategoryTermOutput( $term );
  }

function productCategoryTermOutput( $term ) {
    $term_slug = $term->slug;
    $term_title = $term->name;
    $term_id = $term->term_id;

    $term_slug_display = '';
    if ( !empty( $term_sku ) ) {
      $term_slug_display = ' - ' . __( 'Sku', 'js_composer' ) . ': ' . $term_slug;
    }

    $term_title_display = '';
    if ( !empty( $product_title ) ) {
      $term_title_display = ' - ' . __( 'Title', 'js_composer' ) . ': ' . $term_title;
    }

    $term_id_display = __( 'Id', 'js_composer' ) . ': ' . $term_id;

    $data = array();
    $data['value'] = $term_id;
    $data['label'] = $term_id_display . $term_title_display . $term_slug_display;

    return !empty( $data ) ? $data : false;
  }

//Filters For autocomplete param:
//For suggestion: vc_autocomplete_[shortcode_name]_[param_name]_callback
add_filter( 'vc_autocomplete_products_grid_products_grid_terms_callback', 'productCategoryCategoryAutocompleteSuggesterBySlug', 10, 1 ); // Get suggestion(find). Must return an array
add_filter( 'vc_autocomplete_products_grid_products_grid_terms_render', 'productCategoryCategoryRenderBySlugExact', 10, 1 ); // Render exact category by id. Must return an array (label,value)


vc_map( array(
   "name" => __("Products filter","okthemes"),
   "description" => __('Display WooCommerce products with filter and load more button.','okthemes'),
   "base" => "products_grid",
   'admin_enqueue_css' => array(get_template_directory_uri().'/lib/visualcomposer/styles.css'),
   "category" => __('OKThemes','okthemes'),
   "params" => array(
      array(
        "type" => "checkbox",
        "heading" => __("Extended filter borders?","okthemes"),
        "value" => array(__("Yes, please","okthemes") => "yes" ),
        "param_name" => "extend_filter_borders",
        "description" => __("Extend filter borders to fullscreen? This is just a style effect.","okthemes")
      ),
      array(
         "type" => "dropdown",
         "heading" => __("Layout mode", "okthemes"),
         "param_name" => "grid_layout_mode",
         "value" => array(__("Grid Fit rows", "okthemes") => "fitRows",  __('Carousel', "okthemes") => 'carousel'),
         "description" => __("Layout template.", "okthemes")
      ),
      array(
        "type" => "checkbox",
        "heading" => __("Partially show the carousel hidden items?","okthemes"),
        "value" => array(__("Show the carousel hidden item","okthemes") => "show_hidden_items" ),
        "param_name" => "hidden_items",
        "description" => __("Shows the carousel hidden items with opacity .5","okthemes"),
        "dependency" => Array('element' => 'grid_layout_mode', 'value' => array('carousel'))
      ),
      array(
        "type" => "checkbox",
        "heading" => __("Use navigation?","okthemes"),
        "value" => array(__("Yes, please","okthemes") => "yes" ),
        "param_name" => "carousel_nav",
        "description" => __("Show the carousel next/prev arrows","okthemes"),
        "dependency" => Array('element' => 'grid_layout_mode', 'value' => array('carousel'))
      ),
      array(
        "type" => "checkbox",
        "heading" => __("Use pagination?","okthemes"),
        "value" => array(__("Yes, please","okthemes") => "yes" ),
        "param_name" => "carousel_pag",
        "description" => __("Show the carousel dots navigation","okthemes"),
        "dependency" => Array('element' => 'grid_layout_mode', 'value' => array('carousel'))
      ),
      array(
        "type" => "checkbox",
        "heading" => __("Use autoplay?","okthemes"),
        "value" => array(__("Yes, please","okthemes") => "yes" ),
        "param_name" => "carousel_autoplay",
        "description" => __("Make the carousel autoplay","okthemes"),
        "dependency" => Array('element' => 'grid_layout_mode', 'value' => array('carousel'))
      ),
      array(
        "type" => "checkbox",
        "heading" => __("Scroll slides with mousewheel?","okthemes"),
        "value" => array(__("Yes, please","okthemes") => "true" ),
        "param_name" => "mousewheel",
        "description" => __("Scroll the slides with the help of mousewheel","okthemes")
      ),
      array(
         "type" => "dropdown",
         "heading" => __("Columns count", "okthemes"),
         "param_name" => "products_grid_col_select",
         "value" => array(2,3,4),
         "admin_label" => true,
         "description" => __("Select columns count.", "okthemes"),
      ),

      array(
         "type" => "textfield",
         "heading" => __("Number of posts","okthemes"),
         "param_name" => "products_grid_no_posts",
         "value" => '-1',
         "description" => __("Insert the number of posts to display. Leave empty or insert -1 to display all. Default: -1","okthemes"),
         //"dependency" => Array('element' => 'grid_layout_mode', 'value' => array('fitRows','masonry'))
      ),

      array(
        "type" => "checkbox",
        "heading" => __("Use load more pagination?","okthemes"),
        "value" => array(__("Yes, please","okthemes") => "yes" ),
        "param_name" => "products_grid_pagination",
        "description" => __("Use load more button pagination","okthemes"),
        "dependency" => Array('element' => 'grid_layout_mode', 'value' => array('fitRows','masonry'))
      ),

      array(
          "type" => 'checkbox',
          "heading" => __("Best sellers tab", "okthemes"),
          "param_name" => "best_sellers_tab",
          "description" => __("Show the best sellers tab", "okthemes"),
          "value" => Array(__("Yes, please", "okthemes") => 'use_best_sellers_tab'),
      ),

      array(
          "type" => 'checkbox',
          "heading" => __("Featured tab", "okthemes"),
          "param_name" => "featured_tab",
          "description" => __("Show Featured tab", "okthemes"),
          "value" => Array(__("Yes, please", "okthemes") => 'use_featured_tab'),
      ),

      array(
          "type" => 'checkbox',
          "heading" => __("Sale tab", "okthemes"),
          "param_name" => "sale_tab",
          "description" => __("Show Sale tab", "okthemes"),
          "value" => Array(__("Yes, please", "okthemes") => 'use_sale_tab'),
      ),

      //array(
         //"type" => "gg_taxonomy",
         //"taxonomy" => "product_cat",
         //"heading" => __("Product grid terms", "okthemes"),
         //"param_name" => "products_grid_terms",
         //"description" => __("Select product category terms to display. Leave unchecked to display all.", "okthemes"),
      //),
      array(
          'type' => 'autocomplete',
          'heading' => __( 'Categories', 'js_composer' ),
          'param_name' => 'products_grid_terms',
          'settings' => array(
            'multiple' => true,
            'sortable' => true,
          ),
          'description' => __( 'List of product categories', 'js_composer' ),
        ),
      
      
      array(
         "type" => "textfield",
         "heading" => __("Post IDs", "okthemes"),
         "param_name" => "posts_in",
         "description" => __('Fill this field with posts IDs separated by commas (,) to retrieve only them.', "okthemes")
      ),
       array(
         "type" => "textfield",
         "heading" => __("Exclude Post IDs", "okthemes"),
         "param_name" => "posts_not_in",
         "description" => __('Fill this field with posts IDs separated by commas (,) to exclude them from query.', "okthemes")
      ),
      array(
         "type" => "dropdown",
         "heading" => __("Order by", "okthemes"),
         "param_name" => "orderby",
         "value" => array(
            "Date" => "date",
            "Author" => "author",
            "Title" => "title",
            "Slug" => "name",
            "Date modified" => "modified",
            "ID" => "id"
         ),
         "description" => __("Select how to sort retrieved posts.", "okthemes")
      ),
      array(
         "type" => "dropdown",
         "heading" => __("Order way", "okthemes"),
         "param_name" => "order",
         "value" => array(
            "Descending" => "desc",
            "Ascending" => "asc"
         ),
         "description" => __("Designates the ascending or descending order.", "okthemes")
      ),
      array(
        'type' => 'textfield',
        'heading' => __( 'Extra class name', 'js_composer' ),
        'param_name' => 'el_class',
        'description' => __( 'If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file. For example add "rem_filter_border_top" to remove the filter border-top style.', 'js_composer' )
      ),
      $add_css_animation,

   )
) );

?>