<?php
if(!function_exists('shop_collection_item_output')){
    
    function shop_collection_item_output( $atts, $content = null){
        
        

        $atts =  extract(shortcode_atts( 
            array( 
            'collection_style'             => 'style_1',
        ),$atts )) ;

        $output = '';
        $output .= '<div class="shop-collection-container '.$collection_style.'">';
        $output .= do_shortcode( $content );
        $output .= '</div>';

        return $output;
    }

    add_shortcode( 'shop_collection_item' , 'shop_collection_item_output' );
}

if(!function_exists('shop_collection_inner_item_output')){
    
    function shop_collection_inner_item_output($atts, $content = null){
        
        $output = $collection_item_title = $collection_item_desc = $collection_item_image = $collection_item_image_size = $collection_item_image_customsize_width = $collection_item_image_customsize_height = $thumbnail = '';
        extract(shortcode_atts(array(
            'collection_position'                       => 'left',
            'collection_item_title'                     => '',
            'collection_item_desc'                      => '',
            'collection_item_image'                     => '',
            'collection_item_image_size'                => '',
            'collection_item_image_customsize_width'    => '',
            'collection_item_image_customsize_height'   => '',
            'collection_item_link'                      => '',
            'collection_item_link_title'                => 'Shop the collection',    
        ), $atts));


        $img_id = preg_replace('/[^\d]/', '', $collection_item_image);

        if ($img_id > 0) {
            $attachment_url = wp_get_attachment_url($img_id , 'full');
            $alt_text = get_post_meta($img_id, '_wp_attachment_image_alt', true);
            if ($collection_item_image_size !== 'fullsize') {
                $thumbnail = '<img class="wp-post-image" src="'.gg_aq_resize( $img_id, $collection_item_image_customsize_width, $collection_item_image_customsize_height, true, true ).'" alt="'.$alt_text.'" /> ';
            } else {
                $thumbnail = '<img class="wp-post-image" src="'.$attachment_url.'" alt="'.$alt_text.'" /> ';          
            }
        }

        $url = vc_build_link( $collection_item_link );

        $output  = "\n\t".'<div class="shop-collection-item position-'.$collection_position.'">';

        if ($collection_position == 'right') {

            $output .= "\n\t\t".'<figure>';
            $output .= "\n\t\t\t".$thumbnail;
            $output .= "\n\t\t".'</figure>';

            $output .= "\n\t\t".'<div class="collection-meta">';
            $output .= "\n\t\t\t".'<span class="collection-meta-sep"><span class="gg_sep_line"></span></span>';
            $output .= "\n\t\t\t".'<div class="collection-meta-right">';
            $output .= "\n\t\t\t\t".'<h4>'.$collection_item_title.'</h4>';
            $output .= "\n\t\t\t\t".'<p>'.$collection_item_desc.'</p>';
            if ( strlen( $collection_item_link ) > 0 && strlen( $url['url'] ) > 0 ) {
            $output .= "\n\t\t\t\t".'<a class="btn btn-primary" href="' . esc_attr( $url['url'] ) . '" title="' . esc_attr( $url['title'] ) . '" target="' . ( strlen( $url['target'] ) > 0 ? esc_attr( $url['target'] ) : '_self' ) . '">'.$collection_item_link_title.'</a>';
            }
            $output .= "\n\t\t\t".'</div>';
            $output .= "\n\t\t".'</div>';
        } else {
            $output .= "\n\t\t".'<div class="collection-meta">';
            $output .= "\n\t\t\t".'<div class="collection-meta-left">';
            $output .= "\n\t\t\t".'<h4>'.$collection_item_title.'</h4>';
            $output .= "\n\t\t\t".'<p>'.$collection_item_desc.'</p>';
            if ( strlen( $collection_item_link ) > 0 && strlen( $url['url'] ) > 0 ) {
            $output .= "\n\t\t\t".'<a class="btn btn-primary" href="' . esc_attr( $url['url'] ) . '" title="' . esc_attr( $url['title'] ) . '" target="' . ( strlen( $url['target'] ) > 0 ? esc_attr( $url['target'] ) : '_self' ) . '">'.$collection_item_link_title.'</a>';
            }
            $output .= "\n\t\t\t".'</div>';
            $output .= "\n\t\t\t".'<span class="collection-meta-sep"><span class="gg_sep_line"></span></span>';
            $output .= "\n\t\t\t".'</div>';
            
            $output .= "\n\t\t".'<figure>';
            $output .= "\n\t\t\t".$thumbnail;
            $output .= "\n\t\t".'</figure>';
        }
        $output .= "\n\t".'<div class="clearfix"></div>';
        $output .= "\n\t".'</div>';
        

        return $output;
    }

    add_shortcode( 'shop_collection_inner_item' , 'shop_collection_inner_item_output' );
}

// Parent container
vc_map( array(
    'name'                    => __( 'Shop collection container' , 'okthemes' ),
    'base'                    => 'shop_collection_item',
    'icon'                    => 'icon-wpb-row',
    'description'             => __( 'Container for collections', 'okthemes' ),
    'as_parent'               => array('only' => 'shop_collection_inner_item'), // Use only|except attributes to limit child shortcodes (separate multiple values with comma)
    'content_element'         => true,
    'show_settings_on_create' => true,
    'params'                  => array(

                //BEGIN ADDING PARAMS
                array(
                      "type" => "dropdown",
                      "heading" => __("Collection style", "okthemes"),
                      "param_name" => "collection_style",
                      "value" => array(__("Style 1", "okthemes") => "style_1", __("Style 2", "okthemes") => "style_2"),
                      "description" => __("Choose the collection style", "okthemes")
                ),

                //END ADDING PARAMS

    ),
    "js_view" => 'VcColumnView'
) );

// Nested Element
vc_map( array(
    'name'            => __('Collection', 'okthemes'),
    'base'            => 'shop_collection_inner_item',
    'description'     => __( 'Items "Item".', 'okthemes' ),
    'icon'            => 'icon-wpb-row',
    'content_element' => true,
    'as_child'        => array('only' => 'shop_collection_item'), // Use only|except attributes to limit parent (separate multiple values with comma)
    'params'          => array(
                
                //BEGIN ADDING PARAMS
                //Image size
                array(
                    "type" => "dropdown",
                    "heading" => __("Collection position", "okthemes"),
                    "param_name" => "collection_position",
                    "value" => array(__("Left", "okthemes") => "left", __("Right", "okthemes") => "right"),
                    "description" => __("Select the collection position", "okthemes")
                ),
                array(
                 "type" => "textfield",
                 "heading" => __("Title","okthemes"),
                 "param_name" => "collection_item_title",
                 "admin_label" => true,
                 "description" => __("Insert title here","okthemes")
                ),
                array(
                 "type" => "textarea",
                 "heading" => __("Description","okthemes"),
                 "param_name" => "collection_item_desc",
                 "description" => __("Insert short description here","okthemes")
                ),
                array(
                 "type" => "attach_image",
                 "heading" => __("Featured image", "okthemes"),
                 "param_name" => "collection_item_image",
                 "description" => __("Select image from media library.", "okthemes")
                ),
                //Image size
                array(
                    "type" => "dropdown",
                    "heading" => __("Image size", "okthemes"),
                    "param_name" => "collection_item_image_size",
                    "value" => array(__("Full size", "okthemes") => "fullsize", __("Custom size", "okthemes") => "customsize"),
                    "description" => __("Choose the image size", "okthemes")
                ),
                array(
                    "type" => "textfield",
                    "heading" => __("Custom size - width", "okthemes"),
                    "param_name" => "collection_item_image_customsize_width",
                    "description" => __("Insert the width of the image", "okthemes"),
                    "dependency" => Array('element' => "collection_item_image_size", 'value' => array('customsize'))
                ),
                array(
                    "type" => "textfield",
                    "heading" => __("Custom size - height", "okthemes"),
                    "param_name" => "collection_item_image_customsize_height",
                    "description" => __("Insert the height of the image", "okthemes"),
                    "dependency" => Array('element' => "collection_item_image_size", 'value' => array('customsize'))
                ),
                array(
                    "type" => "vc_link",
                    "heading" => __("Collection URL (Link)", "okthemes"),
                    "param_name" => "collection_item_link",
                    "description" => __("Insert the link to your collection.", "okthemes"),
                ),
                array(
                    "type" => "textfield",
                    "heading" => __("Collection title","okthemes"),
                    "param_name" => "collection_item_link_title",
                    "description" => __("Insert collection button title here","okthemes"),
                    'std' => 'Shop the collection',
                ),
                //END ADDING PARAMS
    ),
) );

// A must for container functionality, replace shop_collection_item with your base name from mapping for parent container
if(class_exists('WPBakeryShortCodesContainer'))
{
    class WPBakeryShortCode_Shop_Collection_Item extends WPBakeryShortCodesContainer {

    }
}

// Replace shop_collection_inner_item with your base name from mapping for nested element
if(class_exists('WPBakeryShortCode'))
{
    class WPBakeryShortCode_Shop_Collection_Inner_Item extends WPBakeryShortCode {

    }
}


?>