<?php
class WPBakeryShortCode_gg_Shop_This_Look extends WPBakeryShortCode {

   public function __construct() {  
         add_shortcode('shop_this_look', array($this, 'gg_shop_this_look'));  
   }

   public function gg_shop_this_look( $atts, $content = null ) { 

         $output = '';
         extract(shortcode_atts(array(
             'shop_this_look_title'               => '',
             'shop_this_look_left_image'          => '',
             'shop_this_look_right_image'         => '',
             'shop_this_look_title_margin_left'   => ''
         ), $atts));

         $img_id_left = preg_replace('/[^\d]/', '', $shop_this_look_left_image);

         if ($img_id_left > 0) {
            $attachment_url = wp_get_attachment_url($img_id_left , 'full');
            $alt_text = get_post_meta($img_id_left, '_wp_attachment_image_alt', true);
            $thumbnail_left = '<img class="wp-post-image" src="'.$attachment_url.'" alt="'.$alt_text.'" /> ';          
        }

        $img_id_right = preg_replace('/[^\d]/', '', $shop_this_look_right_image);

         if ($img_id_right > 0) {
            $attachment_url = wp_get_attachment_url($img_id_right , 'full');
            $alt_text = get_post_meta($img_id_right, '_wp_attachment_image_alt', true);
            $thumbnail_right = '<img class="wp-post-image" src="'.$attachment_url.'" alt="'.$alt_text.'" /> ';          
        }

         $output .= "\n\t".'<div class="shop-this-look">';

         $output .= "\n\t".'<div class="look-holder-left">';
         $output .= "\n\t".'<figure>';
         $output .= "\n\t\t".$thumbnail_left;
         $output .= "\n\t".'</figure>';
         $output .= "\n\t".'</div> ';

         $output .= "\n\t".'<div class="look-holder-right">';
         $output .= "\n\t".'<h4 style="margin-left: '.$shop_this_look_title_margin_left.';">'.gg_wrap_word($shop_this_look_title).'</h4>';
         $output .= "\n\t".wpb_js_remove_wpautop($content, true);
         $output .= "\n\t".'<figure>';
         $output .= "\n\t\t".$thumbnail_right;
         $output .= "\n\t".'</figure>';
         $output .= "\n\t".'</div> ';
         $output .= "\n\t".'</div> ';

         return $output;
         
   }
}

$WPBakeryShortCode_gg_Shop_This_Look = new WPBakeryShortCode_gg_Shop_This_Look();  

vc_map( array(
   "name" => __("Shop this look","okthemes"),
   "description" => __('Shop this look module', 'okthemes'),
   "base" => "shop_this_look",
   "category" => __('OKThemes','okthemes'),
   "params" => array(
      array(
         "type" => "textfield",
         "heading" => __("Title","okthemes"),
         "param_name" => "shop_this_look_title",
         "admin_label" => true,
         "description" => __("Insert title here","okthemes")
      ),
      array(
         "type" => "textfield",
         "heading" => __("Title margin left","okthemes"),
         "param_name" => "shop_this_look_title_margin_left",
         "std" => "-250px",
         "description" => __("Insert title margin left here. Usefull if you want the text to overlap the left image. ","okthemes"),
         "dependency" => Array('element' => "shop_this_look_title", 'not_empty' => true)
      ),
      array(
        'type' => 'textarea_html',
        'heading' => __( 'Text', 'okthemes' ),
        'param_name' => 'content',
        'value' => __( '<p>I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.</p>', 'js_composer' )
      ),
      array(
         "type" => "attach_image",
         "heading" => __("Left image", "okthemes"),
         "param_name" => "shop_this_look_left_image",
         "value" => "",
         "description" => __("Select image from media library.", "okthemes")
      ),
      array(
         "type" => "attach_image",
         "heading" => __("Right image", "okthemes"),
         "param_name" => "shop_this_look_right_image",
         "value" => "",
         "description" => __("Select image from media library.", "okthemes")
      ),
   ),
) );

?>