<?php


if(!function_exists('timeline_item_output')){
    
    function timeline_item_output( $atts, $content = null){
        $atts =  extract(shortcode_atts( 
            array( 
            'timeline_style'             => '',
        ),$atts )) ;

        $output = '';
        $output  .= '<ul id="timeline" class="'.$timeline_style.'">';
        $output .= do_shortcode( $content );
        $output .= '</ul>';

        return $output;
    }

    add_shortcode( 'timeline_item' , 'timeline_item_output' );
}

if(!function_exists('timeline_inner_item_output')){
    
    function timeline_inner_item_output($atts, $content = null){
        
        $output = $header_style = $title = $subtitle = '';
         extract(shortcode_atts(array(
             'title'            => '',
             'date'             => '',
         ), $atts));

        $unique_id = rand();

        $output  = "\n\t".'<li>';
        $output .= "\n\t\t".'<label for="work-'.$unique_id.'">'.$title.'</label>';
        $output .= "\n\t\t".'<input class="radio" id="work-'.$unique_id.'" name="works" type="radio" checked>';
        $output .= "\n\t\t".'<span class="line"><span class="circle"></span></span>';
        $output .= "\n\t\t".'<span class="date">'.$date.'</span>';
        $output .= "\n\t".'</li> ';

        return $output;
    }

    add_shortcode( 'timeline_inner_item' , 'timeline_inner_item_output' );
}

// Parent container
vc_map( array(
    'name'                    => __( 'Timeline Item' , 'okthemes' ),
    'base'                    => 'timeline_item',
    'icon'                    => 'icon-wpb-row',
    'description'             => __( 'Container for Item', 'okthemes' ),
    'as_parent'               => array('only' => 'timeline_inner_item'), // Use only|except attributes to limit child shortcodes (separate multiple values with comma)
    'content_element'         => true,
    'show_settings_on_create' => true,
    'params'                  => array(

                //BEGIN ADDING PARAMS
                array(
                      "type" => "dropdown",
                      "heading" => __("Timeline style", "js_composer"),
                      "param_name" => "timeline_style",
                      "value" => array(__("Horizontal", "js_composer") => "horizontal", __("Vertical", "js_composer") => "vertical"),
                      "description" => __("Choose the timeline style", "js_composer")
                ),

                //END ADDING PARAMS

    ),
    "js_view" => 'VcColumnView'
) );

// Nested Element
vc_map( array(
    'name'            => __('Timeline Items', 'okthemes'),
    'base'            => 'timeline_inner_item',
    'description'     => __( 'Items "Item".', 'okthemes' ),
    'icon'            => 'icon-wpb-row',
    'content_element' => true,
    'as_child'        => array('only' => 'timeline_item'), // Use only|except attributes to limit parent (separate multiple values with comma)
    'params'          => array(
                
                //BEGIN ADDING PARAMS
                array(
                    "type" => "textfield",
                    "heading" => __("Title","okthemes"),
                    "param_name" => "title",
                    "admin_label" => true,
                    "description" => __("Insert the title here","okthemes")
                ),
                array(
                    "type" => "textfield",
                    "heading" => __("Date","okthemes"),
                    "param_name" => "date",
                    "admin_label" => true,
                    "description" => __("Insert the date here","okthemes")
                )

                //END ADDING PARAMS
    ),
) );

// A must for container functionality, replace timeline_Item with your base name from mapping for parent container
if(class_exists('WPBakeryShortCodesContainer'))
{
    class WPBakeryShortCode_Timeline_Item extends WPBakeryShortCodesContainer {

    }
}

// Replace timeline_inner_item with your base name from mapping for nested element
if(class_exists('WPBakeryShortCode'))
{
    class WPBakeryShortCode_Timeline_Inner_Item extends WPBakeryShortCode {

    }
}


?>