<?php
/**
 * Adds gg_Contact_Widget widget.
 */
class gg_Contact_Widget extends WP_Widget {

	/**
	 * Register widget with WordPress.
	 */
	function __construct() {
		parent::__construct(
			'gg_contact_widget', // Base ID
			__('Contact Widget', 'okthemes'), // Name
			array( 'description' => __( 'Contact us Widget', 'okthemes' ), 'classname' => 'contact', ) // Args
		);
	}

	/**
	 * Front-end display of widget.
	 */
	public function widget( $args, $instance ) {

		$title    = apply_filters( 'widget_title', empty( $instance['title'] ) ? '' : $instance['title'], $instance, $this->id_base );
		
		$address = ! empty( $instance['address'] ) ? $instance['address'] : '';
		$address_directions = ! empty( $instance['address_directions'] ) ? $instance['address_directions'] : '';
		
		$phone = ! empty( $instance['phone'] ) ? $instance['phone'] : '';
		$fax = ! empty( $instance['fax'] ) ? $instance['fax'] : '';
		$email = ! empty( $instance['email'] ) ? $instance['email'] : '';

		$extra_details = ! empty( $instance['extra_details'] ) ? $instance['extra_details'] : '';

		echo $args['before_widget'];

		if ( ! empty( $title ) )
			echo $args['before_title'] . $title . $args['after_title'];

		echo '<div class="col-md-6 gg-address-holder">';
			if ( $address )
				echo '<address>'.esc_html($address).' </address>';
			if ( $address_directions )
				echo '<p><a href="//www.google.com/maps/dir/Current+Location/'.esc_html($address_directions).'">' . __('Get directions','okthemes') . '</a></p>';
		echo '</div>';

		echo '<div class="col-md-6 gg-phone-holder">';
			if ( $phone )
				echo '<p>'.esc_html($phone).' </p>';
			if ( $fax )
				echo '<p>'.esc_html($fax).' </p>';
			if ( $email )
				echo '<p><a href="mailto:'.antispambot($email,1).'">'.antispambot($email).'</a></p>';
		echo '</div>';

		if ( $extra_details )
			echo '<div class="clearfix"></div><div class="extra_details">'.esc_html($extra_details).' </div>';	

		echo $args['after_widget'];
	}
	

	/**
	 * Back-end widget form.
	 */
	public function form( $instance ) {
		$instance = wp_parse_args( (array) $instance, array( 'title' => '', 'address' => '', 'address_directions' => '', 'phone' => '', 'fax' => '', 'email' => '', 'extra_details' => '') );	

		$title     			= isset( $instance['title'] ) ? esc_attr( $instance['title'] ) : '';
		$address     		= isset( $instance['address'] ) ? esc_textarea( $instance['address'] ) : '';
		$address_directions	= isset( $instance['address_directions'] ) ? esc_attr( $instance['address_directions'] ) : '';

		$phone				= isset( $instance['phone'] ) ? esc_attr( $instance['phone'] ) : '';
		$fax				= isset( $instance['fax'] ) ? esc_attr( $instance['fax'] ) : '';
		$email				= isset( $instance['email'] ) ? esc_attr( $instance['email'] ) : '';

		$extra_details		= isset( $instance['extra_details'] ) ? esc_attr( $instance['extra_details'] ) : '';
		?>
		
		<!-- Widget Title: Text Input -->
		<p>
			<label for="<?php echo esc_attr( $this->get_field_id( 'title' ) ); ?>"><?php _e('Title:', 'okthemes'); ?></label>
			<input type="text" id="<?php echo esc_attr( $this->get_field_id( 'title' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'title' ) ); ?>" value="<?php echo esc_attr( $title ); ?>" class="widefat" />
		</p>
		
		<!-- Your Phone: Text Input -->
		<p>
			<label for="<?php echo esc_attr( $this->get_field_id( 'phone' ) ); ?>"><?php _e('Your Phone:', 'okthemes'); ?></label>
			<input type="text" id="<?php echo esc_attr( $this->get_field_id( 'phone' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'phone' ) ); ?>" value="<?php echo esc_attr( $phone ); ?>" class="widefat" />
		</p>
		<!-- Your Fax: Text Input -->
		<p>
			<label for="<?php echo esc_attr( $this->get_field_id( 'fax' ) ); ?>"><?php _e('Your Fax:', 'okthemes'); ?></label>
			<input type="text" id="<?php echo esc_attr( $this->get_field_id( 'fax' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'fax' ) ); ?>" value="<?php echo esc_attr( $fax ); ?>" class="widefat" />
		</p>

		<!-- Your E-mail: Text Input -->
		<p>
			<label for="<?php echo esc_attr( $this->get_field_id( 'email' ) ); ?>"><?php _e('Your Email:', 'okthemes'); ?></label>
			<input type="text" id="<?php echo esc_attr( $this->get_field_id( 'email' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'email' ) ); ?>" value="<?php echo esc_attr( $email ); ?>" class="widefat" />
		</p>

		<!-- Your Address: Text Input -->
		<p>
			<label for="<?php echo esc_attr( $this->get_field_id( 'address' ) ); ?>"><?php _e('Your Address:', 'okthemes'); ?></label>
			<textarea class="widefat" id="<?php echo esc_attr( $this->get_field_id( 'address' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name('address') ); ?>"><?php echo esc_attr($address); ?></textarea>
		</p>
		<!-- Address: Directions -->
		<p>
			<label for="<?php echo esc_attr( $this->get_field_id( 'address_directions' ) ); ?>"><?php _e('Directions:', 'okthemes'); ?></label>
			<input type="text" id="<?php echo esc_attr( $this->get_field_id( 'address_directions' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'address_directions' ) ); ?>" value="<?php echo esc_attr( $address_directions ); ?>" class="widefat" />
			<span><?php _e('Insert the longitude and latitude coordinates separated by comma. E.g.: 43.2238916,-76.2575936','okthemes'); ?></span>
		</p>

		<!-- Extra details: Textarea -->
		<p>
			<label for="<?php echo esc_attr( $this->get_field_id( 'extra_details' ) ); ?>"><?php _e('Extra details:', 'okthemes'); ?></label>
			<textarea class="widefat" id="<?php echo esc_attr( $this->get_field_id( 'extra_details' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name('extra_details') ); ?>"><?php echo esc_attr( $extra_details ); ?></textarea>
		</p>

		<?php 
	}


	/**
	 * Sanitize widget form values as they are saved.
	 */
	public function update( $new_instance, $old_instance ) {
		$instance = array();

		$instance['title'] = ( ! empty( $new_instance['title'] ) ) ? strip_tags( $new_instance['title'] ) : '';

		$instance['address_directions'] =  $new_instance['address_directions'];
		$instance['address'] =  $new_instance['address'];

		$instance['phone'] = ( ! empty( $new_instance['phone'] ) ) ? $new_instance['phone'] : '';
		$instance['fax'] = ( ! empty( $new_instance['fax'] ) ) ? $new_instance['fax'] : '';
		$instance['email'] = ( ! empty( $new_instance['email'] ) ) ? $new_instance['email'] : '';

		$instance['extra_details'] = ( ! empty( $new_instance['extra_details'] ) ) ? $new_instance['extra_details'] : '';
		
		return $instance;
	}


} // class gg_Contact_Widget

// register gg_Contact_Widget 
function register_gg_contact_widget() {
    register_widget( 'gg_Contact_Widget' );
}
add_action( 'widgets_init', 'register_gg_contact_widget' );