<?php
    /**
     * Get current users preference
     * @return int
     */
    function gg_voux_get_products_per_page(){
 
        $default = 12;
        $count = $default;
        $options = gg_voux_get_products_per_page_options();
 
        // capture form data and store in session
        if(isset($_POST['gg-voux-wc-products-per-page'])){
            
            // set products per page from dropdown
            $products_max = intval($_POST['gg-voux-wc-products-per-page']);
            if($products_max != 0 && $products_max >= -1){
 
            	if(is_user_logged_in()){
 
            		$user_id = get_current_user_id();
    		    	$limit = get_user_meta( $user_id, '_product_per_page', true );
                    
    		    	if(!$limit){
    		    		add_user_meta( $user_id, '_product_per_page', $products_max);
    		    	}else{
    		    		update_user_meta( $user_id, '_product_per_page', $products_max, $limit);
    		    	}
            	}
                
                WC()->session->gg_voux_product_per_page = $products_max;
                return $products_max;
            }    
        }
 
        // load product limit from user meta
        if(is_user_logged_in() && !isset(WC()->session->gg_voux_product_per_page)){
 
            $user_id = get_current_user_id();
            $limit = get_user_meta( $user_id, '_product_per_page', true );
 
            if(array_key_exists($limit, $options)){
                WC()->session->gg_voux_product_per_page = $limit;
                return $limit;  
            }       
        }
 
        // load product limit from session
        if(isset(WC()->session->gg_voux_product_per_page)){
 
            // set products per page from woo session
            $products_max = intval(WC()->session->gg_voux_product_per_page);
            if($products_max != 0 && $products_max >= -1){
                return $products_max;
            }
        }	
        
        return $count;


    }
    add_filter('loop_shop_per_page','gg_voux_get_products_per_page',30);
 
    /**
     * Fetch list of avaliable options
     * @return array
     */
    function gg_voux_get_products_per_page_options(){
    	$options = apply_filters( 'gg_voux_products_per_page', array(
    		6 => esc_html__('View 6 Products', 'okthemes'),
            12 => esc_html__('View 12 Products', 'okthemes'),
    		24 => esc_html__('View 24 Products', 'okthemes'),
    		48 => esc_html__('View 48 Products', 'okthemes'),
    		96 => esc_html__('View 96 Products', 'okthemes')
        ));
 
    	return $options;
    }
 
    /**
     * Display dropdown form to change amount of products displayed
     * @return void
     */
    function gg_voux_wc_products_per_page(){
 
        $options = gg_voux_get_products_per_page_options();
 
        $current_value = gg_voux_get_products_per_page();

        ?>
        <div class="products-per-page">
            <form action="#" method="POST" class="woocommerce-products-per-page">
                <select name="gg-voux-wc-products-per-page" onchange="this.form.submit()">
                <?php foreach($options as $value => $name): ?>
                    <option value="<?php echo esc_attr($value); ?>" <?php selected($value, $current_value); ?>> <?php echo esc_html($name); ?></option>
                <?php endforeach; ?>        
                </select>
            </form>
        </div>
        <?php
    }
 
    add_action('woocommerce_before_shop_loop', 'gg_voux_wc_products_per_page', 35);
    ?>