<?php
/**
 * WooCommerce Sold Out Products
 *
*/
add_action( 'woocommerce_before_single_product_summary', 'single_sold_out_products_flash', 9 );
add_action( 'woocommerce_before_shop_loop_item_title', 'loop_sold_out_products_flash', 9 );
add_filter( 'woocommerce_product_is_visible', 'make_sold_out_products_visible', 10, 2 );
add_action( 'woocommerce_before_shop_loop_item_title', 'show_hide_loop_sale_flash', 10 );

remove_action( 'woocommerce_before_shop_loop_item_title', 'woocommerce_show_product_loop_sale_flash', 10 );


/**
 * add sold out text to the product image
 */
function single_sold_out_products_flash() {
	global $post, $product;

	if ( ! $product->is_in_stock() ) {
		remove_action( 'woocommerce_before_single_product_summary', 'woocommerce_show_product_sale_flash', 10 );
	}

	if ( ! $product->is_in_stock() ) {
		echo apply_filters( 'woocommerce_sold_out_flash', '<span class="soldout">'.__( 'Sold Out!', 'wc-sold-out-products' ).'</span>', $post, $product );
	}
}

/**
 * add sold out text to the product image on shop page
 */
function loop_sold_out_products_flash() {
	global $post, $product;

	if ( ! $product->is_in_stock() ) {
		echo apply_filters( 'woocommerce_sold_out_flash', '<span class="soldout">'.__( 'Sold Out!', 'wc-sold-out-products' ).'</span>', $post, $product );
	}
}

/**
 * Make all sold out products visible when shortcode is used
 */
function make_sold_out_products_visible( $visible, $product_id ) {
	global $sold_out_shortcode_used;
	if ( $sold_out_shortcode_used ) {
		if ( $visible )
			return $visible;

		$product = get_product( $product_id );
		if ( get_option( 'woocommerce_hide_out_of_stock_items' ) == 'yes' && ! $product->is_in_stock() )
			return true;
		else return $visible;
	} else return $visible;
}

/**
 * Only load sale flash when product not sold out
 */
function show_hide_loop_sale_flash() {
	global $product;
	if ( $product->is_in_stock() ) {
		wc_get_template( 'loop/sale-flash.php' );
	}
}

?>