<?php
/**
 * Default Page
 * Description: Page template with a content container and right sidebar.
 *
 * @package WordPress
 * @subpackage voux
 */
get_header(); ?>

<?php
$page_layout = _get_field('gg_page_layout_select');
$page_container = _get_field('gg_page_container_select');

switch ($page_container) {
    case "1170":
        $page_container_class = 'container';
        break;
    case "fullscreen":
        $page_container_class = 'container-fluid';
        break;
    case NULL:
        $page_container_class = 'container';
        break;
}

switch ($page_layout) {
    case "with_right_sidebar":
        $page_content_class = 'col-xs-12 col-md-9 pull-left';
        $page_sidebar_class = 'col-xs-12 col-md-3 pull-right';
        break;
    case "with_left_sidebar":
        $page_content_class = 'col-xs-12 col-md-9 pull-right';
        $page_sidebar_class = 'col-xs-12 col-md-3 pull-left';
        break;
    case "no_sidebar":
        $page_content_class = 'col-xs-12 col-md-12';
        break;
    case NULL:
        $page_content_class = 'col-xs-12 col-md-9 pull-left';
        $page_sidebar_class = 'col-xs-12 col-md-3 pull-right';
        break;        
}

?>

<section id="content">
    <div class="<?php echo esc_attr($page_container_class); ?>">
        
        <?php if ( $page_layout == 'no_sidebar' ) : ?> 
        <div class="gg-content-separator"></div>
        <?php endif; //Apply full width border ?>

        <div class="row">
            <div class="<?php echo esc_attr($page_content_class); ?>">

                <?php if ( $page_layout != 'no_sidebar' ) : ?> 
                <div class="gg-content-separator"></div>
                <?php endif; //Apply content border ?>

                <?php
                // Start the loop.
                while ( have_posts() ) : the_post();

                    // Include the page content template.
                    get_template_part( 'parts/part', 'page' );

                    // If comments are open or we have at least one comment, load up the comment template.
                    if ( comments_open() || get_comments_number() ) :
                        comments_template();
                    endif;

                // End the loop.
                endwhile;
                ?>

            </div><!-- /.col-9 col-sm-9 col-lg-9 -->

            <?php if ($page_layout !== 'no_sidebar') { ?>
            <div class="<?php echo esc_attr($page_sidebar_class); ?>">
                <aside class="sidebar-nav">
                    <?php get_sidebar(); ?>
                </aside>
                <!--/aside .sidebar-nav -->
            </div><!-- /.col-3 col-sm-3 col-lg-3 -->
            <?php } ?>

        </div>
    </div>    
</section>

<?php get_footer(); ?>