<?php $contact_form_headline = _get_field( 'gg_contact_form_headline' ); ?>

<div class="col-md-4 contact-form-wrapper">

    <?php if ($contact_form_headline) : ?>
    <div class="col-md-12">
        <h3 class="entry-header"><?php echo esc_html($contact_form_headline); ?></h3>
    </div>  
    <?php endif; ?>

    <form id="contact-form" data-bv-message="This value is not valid" data-bv-feedbackicons-valid="glyphicon glyphicon-ok" data-bv-feedbackicons-invalid="glyphicon glyphicon-remove" data-bv-feedbackicons-validating="glyphicon glyphicon-refresh" data-bv-container="tooltip">
    	<div id="cf-msg"></div><!-- Message display -->
        <div class="form-group">
            <label for="name"><?php esc_html_e( 'Name', 'okthemes' ); ?></label>
            <input data-bv-notempty="true" data-bv-notempty-message="<?php esc_html_e( 'The name is required and cannot be empty', 'okthemes' ); ?>" type="text" name="name" id="name" value="" class="form-control" />
        </div>    
        <div class="form-group">    
            <label for="email"><?php esc_html_e( 'Email', 'okthemes' ); ?></label>
            <input data-bv-notempty="true" data-bv-notempty-message="<?php esc_html_e( 'The email is required and cannot be empty', 'okthemes' ); ?>" data-bv-emailaddress="true" data-bv-emailaddress-message="<?php esc_html_e( 'The input is not a valid email address', 'okthemes' ); ?>" type="text" name="email" id="email" value="" class="form-control" />
        </div>
        <div class="form-group">
            <label for="subject"><?php esc_html_e( 'Subject', 'okthemes' ); ?></label>
            <input data-bv-notempty="true" data-bv-notempty-message="<?php esc_html_e( 'The subject is required and cannot be empty', 'okthemes' ); ?>" type="text" name="subject" id="subject" value="" class="form-control" />
        </div>
        <div class="form-group">    
            <label for="message"><?php esc_html_e( 'Message', 'okthemes' ); ?></label>
            <textarea data-bv-notempty="true" data-bv-notempty-message="<?php esc_html_e( 'The message is required and cannot be empty', 'okthemes' ); ?>" name="message" id="message" rows="11" class="form-control"></textarea>
        </div>
            <input name="action" type="hidden" value="cf_action" />
            <input name="post_id" type="hidden" value="<?php echo esc_html($post->ID); ?>" />
          	<?php wp_nonce_field( 'contact_form_html', '_cf_nonce'); ?>
        <div class="form-group">
         	<button type="submit" id="cfs" class="btn btn-primary"><?php esc_html_e( 'Send', 'okthemes' ); ?></button>
        </div>
        </ul>
    </form>

</div><!--Close .contact-form-wrapper -->