<?php
/**
 * The default template for displaying content. Used for both single and index/archive/search.
 *
 * @package WordPress
 * @subpackage voux
 */
?>

<?php 
wp_enqueue_script('magnific');
wp_enqueue_style('magnific');

global $blog_list_thumbnail, $blog_list_content, $blog_layout;
?>

<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>

		<header class="entry-header">
		<?php
			if ( !is_single() ) :
				the_title( sprintf( '<h2 class="entry-title"><a class="gg-ajax-post-handler" data-id="'.get_the_ID().'" href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h2>' );
			endif;
		?>
		<?php if ( !is_single() ) : ?>
			<p class="meta"><?php echo gg_posted_on();?></p>
		<?php endif; ?>
		</header><!-- .entry-header -->

		<?php
			if ( is_single() ) :
				gg_post_thumbnail();
			elseif ( !is_single() && $blog_list_thumbnail ) :
				gg_post_thumbnail();
			elseif ( !is_single() && $blog_layout == 'masonry' ) :
				gg_post_thumbnail();
			elseif ( !is_single() && $blog_layout == 'fitRows' ) :
				gg_post_thumbnail();
			endif;
		?>

		<?php if ( is_single() ) : ?>
				<div class="entry-content">
					<?php the_content( __( 'Continue reading', 'okthemes' ) ); ?>
					<?php wp_link_pages( array( 'before' => '<div class="page-links">' . __( 'Pages:', 'okthemes' ), 'after' => '</div>' ) ); ?>
				</div><!-- .entry-content -->
		<?php elseif ( !is_single() && $blog_list_content ) : ?>
				<div class="entry-excerpt">
					<?php the_excerpt(); ?>
				</div><!-- .entry-content -->
		<?php elseif ( !is_single() && $blog_layout == 'masonry' ) : ?>
				<div class="entry-excerpt">
					<?php the_excerpt(); ?>
				</div><!-- .entry-content -->
		<?php elseif ( !is_single() && $blog_layout == 'fitRows' ) : ?>
				<div class="entry-excerpt">
					<?php the_excerpt(); ?>
				</div><!-- .entry-content -->
		<?php endif; ?>

		<?php if ( is_single() ) : ?>
		<footer class="entry-meta">
			<?php gg_entry_meta(); ?>
			<?php edit_post_link( __( 'Edit', 'okthemes' ), '<span class="edit-link">', '</span>' ); ?>
		</footer><!-- .entry-meta -->
		<?php endif; ?>

</article><!-- #post -->
