<?php
/**
 * The loop that displays the portfolio posts.
 */
?>

<?php
    $port_item_short_desc = _get_field('gg_port_item_short_desc');
    $select_portfolio_open_type = _get_field('gg_select_portfolio_open_type');

    $port_item_lightbox_image = _get_field( 'gg_port_item_lightbox_image');
    $port_item_lightbox_video = _get_field('gg_port_item_lightbox_video');
    $port_item_custom_url = _get_field('gg_port_item_custom_url');

    switch ($select_portfolio_open_type) {
    case "lightbox_image":
      if ($port_item_lightbox_image) {
        $portfolio_hover_icn = '<a class="lightbox-el link-wrapper" href="'.esc_url($port_item_lightbox_image).'"><i class="pe-7s-search"></i></a>';
      }
    break;

    case "lightbox_video":
      if ($port_item_lightbox_video) {
        $portfolio_hover_icn = '<a class="lightbox-el link-wrapper lightbox-video" href="'.esc_url($port_item_lightbox_video).'"><i class="pe-7s-video"></i></a>';
      }
    break;

    case "custom_url":
      if ($port_item_custom_url) {
        $portfolio_hover_icn = '<a class="link-wrapper" href="'.esc_url($port_item_custom_url).'"><i class="pe-7s-link"></i></a>';
      }
    break;

    case "separate_page":
       $portfolio_hover_icn = '<a class="link-wrapper" href="'.esc_url(get_permalink()).'"><i class="pe-7s-browser"></i></a>';
       break;    
    }
?>

<span class="thumbs-wrapper">
  <?php the_post_thumbnail( 'post-thumbnail', array( 'alt' => get_the_title() ) ); ?>
  <div>
    <span class="thumbs-content-align">
      <span class="portfolio-hover-icn"><?php echo $portfolio_hover_icn; ?></span>
      <h4><?php echo get_the_title(); ?></h4>
    </span>
  </div>
</span>