<?php  if (get_theme_mod('portfolio_related_posts', 1) == 1) { 
wp_enqueue_script('magnific');
//Enqueue effect
wp_enqueue_script('hoverdir');
wp_enqueue_script('hoverdir-modernizr');
?>

<?php

if ( 'portfolio_cpt' == get_post_type() ) {

$taxs = wp_get_post_terms( $post->ID, 'portfolio_tag' );

if ( !empty($taxs) ) {

    $tax_ids = array();
    foreach( $taxs as $individual_tax ) {
        $tax_ids[] = $individual_tax->term_id;
    }

    $args = array(
        'tax_query' => array(
            array(
            'taxonomy'  => 'portfolio_tag',
            'terms'     => $tax_ids,
            'operator'  => 'IN'
            )
        ),
        'post__not_in'          => array( $post->ID ),
        'posts_per_page'        => get_theme_mod('portfolio_related_posts_number','3'),
        'ignore_sticky_posts'   => 1
    );

    switch (get_theme_mod('portfolio_related_posts_number','3')) {
        case "4":
           $portfolio_related_col_class = 'col-xs-12 col-sm-6 col-md-3';
        break;
        case "3":
           $portfolio_related_col_class = 'col-xs-12 col-sm-6 col-md-4';
        break;
        case "2":
           $portfolio_related_col_class = 'col-xs-12 col-sm-6 col-md-6';
        break;
        case "1":
           $portfolio_related_col_class = 'col-xs-12 col-md-12';
        break;
        case NULL:
           $portfolio_related_col_class = '';
        break;
    }

$portfolio_tags_query = new wp_query( $args );

if( $portfolio_tags_query->have_posts() ) { ?>

<section class="related-projects">
    <div class="container">

        <h4 class="entry-title"><?php echo get_theme_mod('portfolio_related_posts_title','Related posts'); ?></h4>

        <ul class="row el-grid da-thumbs">
        <?php 

        while ( $portfolio_tags_query->have_posts() ) : $portfolio_tags_query->the_post();

        ?>    

            <li class="<?php echo esc_attr($portfolio_related_col_class); ?>">
                <?php
                $port_item_short_desc = _get_field('gg_port_item_short_desc');
                $select_portfolio_open_type = _get_field('gg_select_portfolio_open_type');

                $port_item_lightbox_image = _get_field( 'gg_port_item_lightbox_image');
                $port_item_lightbox_video = _get_field('gg_port_item_lightbox_video');
                $port_item_custom_url = _get_field('gg_port_item_custom_url');

                switch ($select_portfolio_open_type) {
                case "lightbox_image":
                  if ($port_item_lightbox_image) {
                    $portfolio_hover_icn = '<a class="lightbox-el link-wrapper" href="'.esc_url($port_item_lightbox_image).'"><i class="pe-7s-search"></i></a>';
                  }
                break;

                case "lightbox_video":
                  if ($port_item_lightbox_video) {
                    $portfolio_hover_icn = '<a class="lightbox-el link-wrapper lightbox-video" href="'.esc_url($port_item_lightbox_video).'"><i class="pe-7s-video"></i></a>';
                  }
                break;

                case "custom_url":
                  if ($port_item_custom_url) {
                    $portfolio_hover_icn = '<a class="link-wrapper" href="'.esc_url($port_item_custom_url).'"><i class="pe-7s-link"></i></a>';
                  }
                break;

                case "separate_page":
                   $portfolio_hover_icn = '<a class="link-wrapper" href="'.esc_url(get_permalink()).'"><i class="pe-7s-browser"></i></a>';
                   break;    
                }
            ?>

            <span class="thumbs-wrapper">
              <?php the_post_thumbnail( 'post-thumbnail', array( 'alt' => get_the_title() ) ); ?>
              <div>
                <span class="thumbs-content-align">
                  <span class="portfolio-hover-icn"><?php echo $portfolio_hover_icn; ?></span>
                  <h4><a href="<?php echo esc_url(get_permalink()); ?>"><?php echo get_the_title(); ?></a></h4>
                </span>
              </div>
            </span>
            </li><!-- // portfolio item column -->

        <?php endwhile; ?>
        </ul>

    </div>

</section>

<?php } ?>

<?php } //end check for portfolio tags ?>

<?php } //end check for portfolio post type ?>

<?php wp_reset_postdata(); ?> 

<?php } ?>