<?php
/**
 * The loop that displays a single portfolio post.
 *
 */
?>
<div class="col-xs-12 col-md-12">
	
    <?php 
    $port_post_slideshow_image = _get_field( 'gg_port_post_slideshow_image');

	//Load scripts
    wp_enqueue_script( 'slickcarousel' );
	wp_enqueue_script('magnific');

    if($port_post_slideshow_image) : ?>
	<div class="portfolio-single-slider gg-slick-carousel" data-mousewheel="false" data-slick='{"slidesToShow": 1, "slidesToScroll": 1, "arrows": true, "infinite": true, "adaptiveHeight": true, "rtl": <?php echo is_rtl() ? 'true' : 'false' ?> }'>

		<?php foreach ( $port_post_slideshow_image as $portfolio_slideshow_image ) { ?>
		
		<div class="post-image">
			<img class="wp-post-image" src="<?php echo esc_url($portfolio_slideshow_image['url']); ?>" alt="<?php echo esc_html($portfolio_slideshow_image['alt']); ?>" />		
			<p><?php echo esc_html($portfolio_slideshow_image['caption']); ?></p>
		</div>

		<?php } ?>
	</div><!-- /.carousel .slide -->
	<?php endif; ?>

</div><!-- /.col-xs-12 .col-md-12 -->


<div class="col-xs-12 col-md-12 portfolio-single-fullwidth-content <?php if(trim($post->post_content) == '' ) echo 'entry-no-content'; ?>">
<div class="entry-content">	
	<?php the_content(); ?>
	<?php wp_link_pages( array( 'before' => '<div class="page-link">' . __( 'Pages:', 'okthemes' ), 'after' => '</div>' ) ); ?>
</div>
</div>
