<?php
/**
 * Search Results Template
 *
 * @package WordPress
 * @subpackage voux
 */
get_header(); ?>

<?php
$search_layout = get_theme_mod('search_page_style','right');
switch ($search_layout) {
    case "left":
        $search_content_class = 'col-xs-12 col-md-9 pull-right';
        $search_sidebar_class = 'col-xs-12 col-md-3 pull-left';
        $search_col_class     = 'col-xs-12 col-sm-6 col-md-6';
        break;
    case "right":
        $search_content_class = 'col-xs-12 col-md-9 pull-left';
        $search_sidebar_class = 'col-xs-12 col-md-3 pull-right';
        $search_col_class     = 'col-xs-12 col-sm-6 col-md-6';
        break;
    case "fullwidth":
        $search_content_class = 'col-xs-12 col-md-12';
        $search_sidebar_class = 'col-xs-12 col-md-12';
        $search_col_class     = 'col-xs-12 col-sm-6 col-md-4';
        break; 
    case NULL:
        $search_content_class = 'col-xs-12 col-md-9 pull-left';
        $search_sidebar_class = 'col-xs-12 col-md-3 pull-right';
        $search_col_class     = 'col-xs-12 col-sm-6 col-md-6';
        break;       
}

wp_enqueue_style('isotope');
wp_enqueue_script( 'gg-isotope' );

?>

<section id="content">
    <div class="container">

        <?php if ( $search_layout == 'fullwidth' ) : ?> 
        <div class="gg-content-separator"></div>
        <?php endif; //Apply full width border ?>

        <div class="row">

        <div class="<?php echo esc_attr($search_content_class); ?>">

            <?php if ( $search_layout != 'fullwidth' ) : ?> 
            <div class="gg-content-separator"></div>
            <?php endif; //Apply content border ?>

            <?php if ( have_posts() ) : ?>
    		<div class="gg_posts_grid">
                <ul class="el-grid" data-layout-mode="masonry" data-gap="gap">
                <?php while (have_posts()) : the_post(); ?>

                    <?php if( 'product' == get_post_type() ): ?>      
                        <li class="isotope-item <?php echo esc_attr($search_col_class); ?>"><?php wc_get_template_part( 'content', 'product-vc' ); ?></li>
                    <?php // for any other post type ?>
                    <?php else : ?>
                        <li class="isotope-item <?php echo esc_attr($search_col_class); ?>"><?php get_template_part( 'parts/part', get_post_format() ); ?></li>      
                    <?php endif; ?>

                <?php endwhile; ?>
                </ul>
            </div>

            <?php if (function_exists("gg_pagination")) {
                gg_pagination($wp_query->max_num_pages);
            } ?>

            <?php // If no content, include the "No posts found" template.
            else :
                get_template_part( 'parts/part', 'none' );
            endif;
            ?>

        </div>

        <?php if ($search_layout !='fullwidth') { ?>
        <div class="<?php echo esc_attr($search_sidebar_class); ?>">
            <aside class="sidebar-nav search">
                <?php get_sidebar(); ?>
            </aside>
            <!--/aside .sidebar-nav -->
        </div><!-- /.col-4 col-sm-4 col-lg-4 -->
        <?php } ?>

    </div><!-- /.row .content -->

</div><!--/.container -->    
</section>

<?php get_footer(); ?>