<?php
/**
 * The Right Sidebar displayed on page templates.
 *
 * @package WordPress
 * @subpackage voux
 */
?>

<?php 
if (function_exists('dynamic_sidebar')) {
	
	if( is_page_template('theme-templates/portfolio.php') ) {
		
		$dynamic_sidebar = 'sidebar-portfolio';

	} elseif( is_page_template('theme-templates/contact.php') ) {
		
		$dynamic_sidebar = 'sidebar-contact';

	} elseif( is_woocommerce_activated() && is_product() ) {
		
		$dynamic_sidebar = 'sidebar-product';

	} elseif( is_woocommerce_activated() && is_woocommerce() ) {
		
		$dynamic_sidebar = 'sidebar-shop';

	} elseif( is_search() ) {
		
		$dynamic_sidebar = 'sidebar-search';			

	} elseif( is_single() || is_home() || is_category() || is_archive() ) {
		
		$dynamic_sidebar = 'sidebar-posts';

	} else { //else default sidebar
		
		$dynamic_sidebar = 'sidebar-page';

	}
}
?>

<?php if ( is_active_sidebar( $dynamic_sidebar ) ) : ?>
    <?php dynamic_sidebar( $dynamic_sidebar ); ?>
<?php else : ?>
	<div class="gg-widget">
		<h4 class="widget-title"><?php _e('Configure Widgets','okthemes'); ?></h4>
		<p class="widget-not-config"><?php _e('The widgets are not configured.','okthemes'); ?><a href="<?php echo admin_url( 'widgets.php' ); ?>"><strong><?php _e('Click here','okthemes'); ?></strong></a> <?php _e('to go to your admin screen and configure them.','okthemes'); ?></p>
	</div>
<?php endif; ?>