<?php
/**
 * Default Post Template
 *
 * @package WordPress
 * @subpackage voux
 */
get_header(); ?>

<?php

$page_layout = _get_field('gg_page_layout_select');
$page_container = _get_field('gg_page_container_select');

$blog_share_box = _get_field('gg_post_social_share');
$blog_nav = _get_field('gg_post_navigation');

switch ($page_layout) {
    case "with_right_sidebar":
        $page_content_class = 'col-xs-12 col-md-9 pull-left';
        $page_sidebar_class = 'col-xs-12 col-md-3 pull-right';
        break;
    case "with_left_sidebar":
        $page_content_class = 'col-xs-12 col-md-9 pull-right';
        $page_sidebar_class = 'col-xs-12 col-md-3 pull-left';
        break;
    case "no_sidebar":
        $page_content_class = 'col-xs-12 col-md-12';
        break;
    case NULL:
        $page_content_class = 'col-xs-12 col-md-9 pull-left';
        $page_sidebar_class = 'col-xs-12 col-md-3 pull-right';
        break;        
}

switch ($page_container) {
    case "1170":
        $page_container_class = 'container';
        break;
    case "fullscreen":
        $page_container_class = 'container-fluid';
        break;
    case NULL:
        $page_container_class = 'container';
        break;
}

?>

<?php while (have_posts()) : the_post(); ?>

<section id="content">
    <div class="<?php echo esc_attr($page_container_class); ?>">
        <div class="row">

            <?php if ( $page_layout == 'no_sidebar' ) : ?> 
            <div class="gg-content-separator"></div>
            <?php endif; //Apply full width border ?>

            <div class="<?php echo esc_attr($page_content_class); ?>">

                <?php if ( $page_layout != 'no_sidebar' ) : ?>
                <p class="meta"><?php echo gg_posted_on();?></p>
                <div class="gg-content-separator"></div>
                <?php endif; //Apply content border ?>

                <?php get_template_part( 'parts/part', get_post_format() ); ?>

                <?php
                if ( $blog_nav || $blog_nav == NULL ) { 
                    // Previous/next post navigation.
                    $args = array(
                        'prev_text'          => __( 'Previous post','okthemes' ),
                        'next_text'          => __( 'Next post','okthemes' )
                    );
                    the_post_navigation( $args );
                }
                endwhile; // end of the loop. ?>
                
                <?php if ( $blog_share_box || $blog_share_box == NULL ) { 
                    get_template_part( 'parts/part', 'socialshare' );
                } ?>

                <?php comments_template( '', true ); ?>

            </div><!-- /.col-9 col-sm-9 col-lg-9 -->

            <?php if (($page_layout !== 'no_sidebar')) { ?>
            <div class="<?php echo esc_attr($page_sidebar_class); ?>">
                <aside class="sidebar-nav">
                    <?php get_sidebar(); ?>
                </aside>
                <!--/aside .sidebar-nav -->
            </div><!-- /.col-4 col-sm-4 col-lg-4 -->
            <?php } ?>

        </div><!-- /.row -->
    </div><!--/.container -->    
</section>

<?php get_footer(); ?>