<?php
/**
 * The template for displaying Archive Portfolio pages.
 *
 * @package WordPress
 * @subpackage voux
 */
get_header(); ?>

<?php

//Load effect
wp_enqueue_script('hoverdir');
wp_enqueue_script('hoverdir-modernizr');

//Load magnific 
wp_enqueue_script('magnific');
wp_enqueue_style('magnific');

//Load isotope 
wp_enqueue_script( 'gg-isotope' );


$archive_portfolio_inner_layout = get_theme_mod('archive_portfolio_page_style','right');
switch ($archive_portfolio_inner_layout) {
    case "left":
        $archive_portfolio_content_class = 'col-xs-12 col-md-9 pull-right';
        $archive_portfolio_sidebar_class = 'col-xs-12 col-md-3 pull-left';
        break;
    case "right":
        $archive_portfolio_content_class = 'col-xs-12 col-md-9 pull-left';
        $archive_portfolio_sidebar_class = 'col-xs-12 col-md-3 pull-right';
        break;
    case "fullwidth":
        $archive_portfolio_content_class = 'col-xs-12 col-md-12';
        $archive_portfolio_sidebar_class = 'col-xs-12 col-md-12';
        break;        
}

$archive_portfolio_page_columns = get_theme_mod('archive_portfolio_page_columns','three_columns');
switch ($archive_portfolio_page_columns) {
    case "four_columns":
        $archive_portfolio_col_class = 'col-xs-6 col-md-3';
        break;
    case "three_columns":
        $archive_portfolio_col_class = 'col-xs-12 col-md-4';
        break;
    case "two_columns":
        $archive_portfolio_col_class = 'col-xs-12 col-md-6';
        break;           
}

?>

    <?php if (have_posts()) :
    // Queue the first post.
    the_post(); ?>

     <section id="content">
        <div class="container">

            <?php if ( $archive_portfolio_inner_layout == 'fullwidth' ) : ?> 
            <div class="gg-content-separator"></div>
            <?php endif; //Apply full width border ?>

            <div class="row">
                <div class="<?php echo esc_attr($archive_portfolio_content_class); ?>">

                    <?php if ( $archive_portfolio_inner_layout != 'fullwidth' ) : ?> 
                    <div class="gg-content-separator"></div>
                    <?php endif; //Apply content border ?>

                    <?php
                    // Rewind the loop back
                        rewind_posts();
                    ?>

                    <div class="gg_posts_grid">
                        <ul class="el-grid da-thumbs" data-layout-mode="fitRows" data-gap="gap">

                        <?php while (have_posts()) : the_post(); ?>
                            <li class="<?php echo esc_attr($archive_portfolio_col_class); ?> isotope-item" >
                                <?php get_template_part( 'parts/part','portfolio' ); ?>
                            </li><!-- // portfolio item column -->
                        <?php endwhile; ?>

                        </ul>
                    </div>

                    <?php if (function_exists("gg_pagination")) {
                        gg_pagination($wp_query->max_num_pages);
                    } ?>

                    <?php endif; ?>
                </div>
        
                <?php if ($archive_portfolio_inner_layout != 'fullwidth') { ?>
                <div class="<?php echo esc_attr($archive_portfolio_sidebar_class); ?>">
                    <aside class="sidebar-nav">
                        <?php get_sidebar(); ?>
                    </aside>
                    <!--/aside .sidebar-nav -->
                </div>
                <?php } ?>
            </div><!-- /.row -->
        </div><!-- /.container -->
    </section><!-- /#content -->
<?php get_footer(); ?>