<?php
/**
 * Template Name: Blog page
 *
 * @package WordPress
 * @subpackage voux
 */
get_header(); ?>

<?php
global $blog_list_thumbnail, $blog_list_content, $blog_layout;

$blog_list_thumbnail = _get_field('gg_blog_list_thumbnail');
$blog_list_content = _get_field('gg_blog_list_content');

$page_layout = _get_field('gg_page_layout_select');
$page_container = _get_field('gg_page_container_select');

$blog_layout = _get_field('gg_blog_layout');
$blog_layout_style = _get_field('gg_blog_layout_style');
$blog_columns = _get_field('gg_blog_columns');
$blog_no_posts = _get_field('gg_blog_no_of_posts_to_show');

$blog_pagination = _get_field('gg_blog_pagination');

switch ($blog_columns) {
    case "4":
       $blog_columns_class = 'col-xs-12 col-sm-6 col-md-3';
    break;
    case "3":
       $blog_columns_class = 'col-xs-12 col-sm-6 col-md-4';
    break;
    case "2":
       $blog_columns_class = 'col-xs-12 col-sm-6 col-md-6';
    break;
    case "1":
       $blog_columns_class = 'col-xs-12 col-md-12';
    break;
    case NULL:
       $blog_columns_class = '';
    break;
}

switch ($page_container) {
    case "1170":
        $page_container_class = 'container';
        break;
    case "fullscreen":
        $page_container_class = 'container-fluid';
        break;
    case NULL:
        $page_container_class = 'container';
        break;
}

switch ($page_layout) {
    case "with_right_sidebar":
        $page_content_class = 'col-xs-12 col-md-9 pull-left';
        $page_sidebar_class = 'col-xs-12 col-md-3 pull-right';
        break;
    case "with_left_sidebar":
        $page_content_class = 'col-xs-12 col-md-9 pull-right';
        $page_sidebar_class = 'col-xs-12 col-md-3 pull-left';
        break;
    case "no_sidebar":
        $page_content_class = 'col-xs-12 col-md-12';
        break;
    case NULL:
        $page_content_class = 'col-xs-12 col-md-9 pull-left';
        $page_sidebar_class = 'col-xs-12 col-md-3 pull-right';
        break;        
}

//Enqueue isotope
if ($blog_layout != 'list') {
    wp_enqueue_style('isotope');
    wp_enqueue_script( 'gg-isotope' );
}

//Enqueue magnific
wp_enqueue_script( 'gg-magnific' );
wp_enqueue_style( 'gg-magnific' );

//Enqueue infinitescroll
if ($blog_pagination == 'ajax_load') {
    wp_enqueue_script( 'infinitescroll' );
    wp_enqueue_script( 'manual-trigger' );
}

global $more;

// WP_Query arguments
$paged = ( get_query_var('paged') ) ? get_query_var('paged') : 1;
$args = array (
    'post_type'              => 'post',
    'posts_per_page'         => $blog_no_posts,
    'paged' => $paged
);
// The Query
$blog_query = new WP_Query( $args );
?>


<section id="content">
    <div class="<?php echo esc_attr($page_container_class); ?>">
        
        <?php if ( $page_layout == 'no_sidebar' ) : ?> 
        <div class="gg-content-separator"></div>
        <?php endif; //Apply full width border ?>

        <div class="row">
            <div class="<?php echo esc_attr($page_content_class); ?>">

                <?php if ( $page_layout != 'no_sidebar' ) : ?> 
                <div class="gg-content-separator"></div>
                <?php endif; //Apply content border ?>
    
                <div class="gg_posts_grid">
                <?php if ( $blog_query->have_posts() ) : ?>
                    <ul class="el-grid <?php if($blog_layout_style == 'nogap') echo 'nogap-cols'; ?>" data-layout-mode="<?php echo esc_attr($blog_layout); ?>" data-gap="<?php echo esc_attr($blog_layout_style); ?>" data-pagination="<?php echo esc_attr($blog_pagination); ?>">
                    <?php while ( $blog_query->have_posts() ) : $blog_query->the_post(); $more = 0; ?>
                        
                        <?php if ($blog_layout == 'list') : ?>
                            <li class="gg-post-list-item">
                                <?php get_template_part( 'parts/part-list', get_post_format() ); ?>
                                <div id="ajax-content-<?php the_ID(); ?>" class="ajax-content"></div>
                            </li>
                        <?php else: ?>
                            <li class="isotope-item <?php echo esc_attr($blog_columns_class); ?>"><?php get_template_part( 'parts/part', get_post_format() ); ?></li>
                        <?php endif; ?>
                    <?php endwhile; ?>

                    </ul>

                    <?php 
                    if ($blog_pagination == 'ajax_load') { ?>
                        <div class="load-more-anim"></div>
                        <div class="pagination-load-more">
                            <span class="pagination-span">
                            <?php next_posts_link('Load more posts', $blog_query->max_num_pages) ?>
                            </span>
                        </div>

                    <?php } else {
                        
                        if (function_exists("gg_pagination")) {
                            gg_pagination($blog_query->max_num_pages);
                        }
                    } ?>

                <?php 
                // clean up after the query and pagination
                wp_reset_postdata(); 
                ?>

                <?php else : ?>

                    <?php get_template_part( 'parts/part', 'none' ); ?>

                <?php endif; // end have_posts() check ?>
                </div><!--/ .gg_posts_grid-->
            </div>

            <?php if (($page_layout !== 'no_sidebar')) { ?>
            <div class="<?php echo esc_attr($page_sidebar_class); if ( $page_layout != 'no_sidebar' ) echo ' gg-sidebar-move-up'; ?>">
                <aside class="sidebar-nav">
                    <?php get_sidebar(); ?>
                </aside>
                <!--/aside .sidebar-nav -->
            </div><!-- /.col-4 col-sm-4 col-lg-4 -->
            <?php } ?>

        </div>
    </div>    
</section>
<?php get_footer(); ?>