<?php
/**
 * Template Name: Coming soon page
 *
 * @package WordPress
 * @subpackage voux
 */

get_header();

//Enqueue countdown script
wp_enqueue_script('countdown');

if ( has_post_thumbnail() ) {
    $image_url = wp_get_attachment_image_src( get_post_thumbnail_id( $post->ID ), 'full' );
    $image_url_html = 'style="background-image: url('.esc_url($image_url[0]).');"';
} else {
    $image_url_html = '';
}

$coming_soon_text = _get_field('gg_coming_soon_text');
$coming_soon_date = _get_field('gg_coming_soon_date');
$coming_soon_newsletter = _get_field('gg_coming_soon_newsletter');
?>

<section id="content">
    <div class="container-fluid">
        <div class="row">
            <div class="col-md-12">
                <div class="coming-soon-wrapper" <?php echo $image_url_html; ?> >
                    
                    <div class="coming-soon-meta">
                        
                        <h1><?php echo esc_html( get_bloginfo('name','display')); ?></h1>

                        <?php if ($coming_soon_text) : ?>
                        <h2><?php echo esc_html($coming_soon_text); ?></h2>
                        <?php endif; ?>

                        <?php if (class_exists('MC4WP_Lite_Widget')) : ?>
                        <?php if ($coming_soon_newsletter) : ?>
                        <div class="col-md-9 gg-newsletter-widget">
                            <?php the_widget( 'MC4WP_Lite_Widget', array('title' => 'Email Sign Up'), array() ); ?>
                        </div>
                        <?php endif; ?>
                        <?php endif; ?>
                    </div>

                    <?php if ($coming_soon_date) : ?>
                    <div class="coming-soon-countdown">
                        <div id="countdown" data-date="<?php echo esc_html($coming_soon_date); ?>"></div>
                    </div>
                    <?php endif; ?>

                </div>
            </div><!-- /.col-md-12 -->
        </div>
    </div>    
</section>

<?php get_footer(); ?>