<?php
/**
 * Template Name: Contact Page
 *
 * @package WordPress
 * @subpackage voux
 */
get_header(); ?>

<?php
$page_layout = _get_field('gg_page_layout_select','','no_sidebar');
$page_container = _get_field('gg_page_container_select','','1170');

$page_content_class = 'col-xs-12 col-md-9';
$page_sidebar_class = 'col-xs-12 col-md-3';
$page_container_class = 'container-fluid gg-master-container';

switch ($page_container) {
    case "1170":
        $page_container_class = 'container';
        break;
    case "fullscreen":
        $page_container_class = 'container-fluid gg-master-container';
        break;
    case NULL:
        $page_container_class = 'container';
        break;
}

switch ($page_layout) {
    case "with_right_sidebar":
        $page_content_class = 'col-xs-12 col-md-9 pull-left';
        $page_sidebar_class = 'col-xs-12 col-md-3 pull-right';
        break;
    case "with_left_sidebar":
        $page_content_class = 'col-xs-12 col-md-9 pull-right';
        $page_sidebar_class = 'col-xs-12 col-md-3 pull-left';
        break;
    case "no_sidebar":
        $page_content_class = 'col-xs-12 col-md-12';
        break;
    case NULL:
        $page_content_class = 'col-xs-12 col-md-9 pull-left';
        $page_sidebar_class = 'col-xs-12 col-md-3 pull-right';
        break;        
}

?>

<?php

$contact_form = _get_field( 'gg_contact_form', '', true );

$contact_phone = _get_field( 'gg_contact_phone','','UK: +44 7861779302<br />International: +555 555 5569<br />EU: +44 7861779304' );
$contact_email = _get_field( 'gg_contact_email','','office@email.com' );
$contact_address = _get_field( 'gg_contact_address','','VOUX’s London Office');
$contact_get_directions = _get_field( 'gg_contact_get_directions','',true );

$contact_map = _get_field( 'gg_contact_map', '', true);
$contact_map_latitude = _get_field( 'gg_contact_map_latitude','','37.3350786');
$contact_map_longitude = _get_field( 'gg_contact_map_longitude','','-122.0295772' );
$contact_zoom = _get_field( 'gg_contact_zoom','','10' );
$contact_map_infowindow = _get_field( 'gg_contact_map_infowindow' );
$contact_map_infowindow_clean = preg_replace('/^\s+|\n|\r|\s+$/m', '', $contact_map_infowindow);
$contact_map_infowindow_title = _get_field( 'gg_contact_map_infowindow_title' );

$address_directions = implode(', ', array_filter(array($contact_map_latitude, $contact_map_longitude)));

$allowed_html =  array(
    'a' => array(
        'href' => array(),
        'title' => array()
    ),
    'br' => array(),
    'em' => array(),
    'strong' => array(),
    'p' => array(),
);

?>

<?php if ($contact_map) {
//Enqueue scripts
wp_enqueue_script('google-map-api');
wp_enqueue_script('maplace');
$map_marker = get_template_directory_uri() .'/images/map-marker.png';
?>

<!-- Map script -->
<script type="text/javascript">
;(function ($, window, undefined) {
$(document).ready(function() {

var contact_map = new Maplace({
    locations:
        [{
            lat: <?php echo esc_js($contact_map_latitude); ?>,
            lon: <?php echo esc_js($contact_map_longitude); ?>,
            icon : <?php echo json_encode($map_marker); ?>,
            title: <?php echo json_encode($contact_map_infowindow_title); ?>,
            html: <?php echo json_encode($contact_map_infowindow_clean); ?>,
            zoom: <?php echo json_encode($contact_zoom, JSON_NUMERIC_CHECK); ?>
        }
    ],
    map_div: '#contact-map',
    styles: {
        'LightGrey': [{"featureType":"water","elementType":"geometry.fill","stylers":[{"color":"#d3d3d3"}]},{"featureType":"transit","stylers":[{"color":"#808080"},{"visibility":"off"}]},{"featureType":"road.highway","elementType":"geometry.stroke","stylers":[{"visibility":"on"},{"color":"#b3b3b3"}]},{"featureType":"road.highway","elementType":"geometry.fill","stylers":[{"color":"#ffffff"}]},{"featureType":"road.local","elementType":"geometry.fill","stylers":[{"visibility":"on"},{"color":"#ffffff"},{"weight":1.8}]},{"featureType":"road.local","elementType":"geometry.stroke","stylers":[{"color":"#d7d7d7"}]},{"featureType":"poi","elementType":"geometry.fill","stylers":[{"visibility":"on"},{"color":"#ebebeb"}]},{"featureType":"administrative","elementType":"geometry","stylers":[{"color":"#a7a7a7"}]},{"featureType":"road.arterial","elementType":"geometry.fill","stylers":[{"color":"#ffffff"}]},{"featureType":"road.arterial","elementType":"geometry.fill","stylers":[{"color":"#ffffff"}]},{"featureType":"landscape","elementType":"geometry.fill","stylers":[{"visibility":"on"},{"color":"#efefef"}]},{"featureType":"road","elementType":"labels.text.fill","stylers":[{"color":"#696969"}]},{"featureType":"administrative","elementType":"labels.text.fill","stylers":[{"visibility":"on"},{"color":"#737373"}]},{"featureType":"poi","elementType":"labels.icon","stylers":[{"visibility":"off"}]},{"featureType":"poi","elementType":"labels","stylers":[{"visibility":"off"}]},{"featureType":"road.arterial","elementType":"geometry.stroke","stylers":[{"color":"#d6d6d6"}]},{"featureType":"road","elementType":"labels.icon","stylers":[{"visibility":"off"}]},{},{"featureType":"poi","elementType":"geometry.fill","stylers":[{"color":"#dadada"}]}]
    },

});

contact_map.Load();

});//ready

})(jQuery, this);

</script>
<?php } ?>


<section id="content">
    <div class="<?php echo esc_attr($page_container_class); ?>">
    
        <?php if ( $page_layout == 'no_sidebar' ) : ?> 
        <div class="gg-content-separator"></div>
        <?php endif; //Apply full width border ?>

        <div class="row">
            <div class="<?php echo esc_attr($page_content_class); ?>">

                <?php if ( $page_layout != 'no_sidebar' ) : ?> 
                <div class="gg-content-separator"></div>
                <?php endif; //Apply content border ?>

                <?php
                // Start the loop.
                while ( have_posts() ) : the_post();

                    // Include the page content template.
                    get_template_part( 'parts/part', 'page' );

                    // If comments are open or we have at least one comment, load up the comment template.
                    if ( comments_open() || get_comments_number() ) :
                        comments_template();
                    endif;

                // End the loop.
                endwhile;
                ?>

                <div class="row contact-details">

                    <div class="col-md-3 col-md-offset-3">
                        <?php if ($contact_address): ?>
                        <address>
                            <?php echo wp_kses($contact_address,$allowed_html); ?>
                        </address>
                        <?php endif; ?> 
                        <?php if ($contact_get_directions) : ?>
                        <a id="gg-get-directions" href="//www.google.com/maps/dir/Current+Location/<?php echo esc_html($address_directions); ?>"><?php esc_html_e('Get directions', 'okthemes'); ?></a>
                        <?php endif; ?>  
                    </div>
                    
                    <div class="col-md-3">
                        <?php if ($contact_phone) : ?>
                        <p>
                            <?php echo wp_kses($contact_phone,$allowed_html); ?>
                        </p>
                        <?php endif; ?> 

                        <?php if ($contact_email) : ?>
                        <p><a class="gg-contact-email" href="mailto:<?php echo antispambot($contact_email,1); ?>"><?php echo antispambot($contact_email); ?></a></p>
                        <?php endif; ?>
                    </div>
                </div>

                <?php if ($contact_form) : ?>
                <div class="row">
                    <?php if ($contact_map) { ?>
                    <div id="contact-map" class="col-md-8"></div>
                    <?php } ?>
                    <?php get_template_part( 'parts/part','contact-form' ); ?>
                </div><!-- /.row -->
                <?php endif; ?>

            </div><!-- /.col-9 col-sm-9 col-lg-9 -->

            <?php if ($page_layout !== 'no_sidebar') { ?>
            <div class="<?php echo esc_attr($page_sidebar_class); ?>">
                <aside class="sidebar-nav">
                    <?php get_sidebar(); ?>
                </aside>
                <!--/aside .sidebar-nav -->
            </div><!-- /.col-3 col-sm-3 col-lg-3 -->
            <?php } ?>
        </div>
    </div>    
</section>



<?php get_footer(); ?>