<?php
/**
 * Template Name: Portfolio page
 *
 * @package WordPress
 * @subpackage voux
 */
get_header(); ?>

<?php
//Portfolio Page Layout 

$page_layout = _get_field('gg_page_layout_select');
$page_container = _get_field('gg_page_container_select');

$portfolio_layout = _get_field('gg_portfolio_layout');
$portfolio_layout_style = _get_field('gg_portfolio_layout_style');
$portfolio_columns = _get_field('gg_portfolio_columns');
$portfolio_no_posts = _get_field('gg_portfolio_no_of_posts_to_show');

$portfolio_pagination = _get_field('gg_portfolio_pagination');

switch ($page_container) {
    case "1170":
        $page_container_class = 'container';
        break;
    case "fullscreen":
        $page_container_class = 'container-fluid';
        break;
    case NULL:
        $page_container_class = 'container';
    break;
}

switch ($page_layout) {
    case "with_right_sidebar":
        $page_content_class = 'col-xs-12 col-md-9 pull-left';
        $page_sidebar_class = 'col-xs-12 col-md-3 pull-right';
        break;
    case "with_left_sidebar":
        $page_content_class = 'col-xs-12 col-md-9 pull-right';
        $page_sidebar_class = 'col-xs-12 col-md-3 pull-left';
        break;
    case "no_sidebar":
        $page_content_class = 'col-xs-12 col-md-12';
        break; 
    case NULL:
        $page_content_class = 'col-xs-12 col-md-9 pull-left';
        $page_sidebar_class = 'col-xs-12 col-md-3 pull-right';
    break;        
}

switch ($portfolio_columns) {
    case "4":
       $portfolio_columns_class = 'col-xs-12 col-sm-6 col-md-3';
    break;
    case "3":
       $portfolio_columns_class = 'col-xs-12 col-sm-6 col-md-4';
    break;
    case "2":
       $portfolio_columns_class = 'col-xs-12 col-sm-6 col-md-6';
    break;
    case "1":
       $portfolio_columns_class = 'col-xs-12 col-md-12';
    break;
    case NULL:
       $portfolio_columns_class = '';
    break;
}

//Enqueue effect
wp_enqueue_script('hoverdir');
wp_enqueue_script('hoverdir-modernizr');

//Enqueue infinitescroll
if ($portfolio_pagination == 'ajax_load') {
    wp_enqueue_script( 'infinitescroll' );
    wp_enqueue_script( 'manual-trigger' );
}
//Enqueue carousel
if ($portfolio_layout != 'carousel' ) {
    wp_enqueue_script( 'gg-isotope' );
} else {
    wp_enqueue_script( 'slickcarousel' );
    wp_enqueue_script( 'mousewheel' );

}


//Portfolio Post Layout
$portfolio_cat_filter = _get_field('gg_portfolio_cat_filter');
$terms = _get_field( 'gg_portfolio_tax', 'type=taxonomy&taxonomy=portfolio_category' );

//Verify if a term is selected in the backend and get the slug
if (!empty($terms)) {
    $term_slug = $terms[0]->slug;
} else {
    $term_slug = '';
}

if ($portfolio_layout == 'carousel' ) {
    $isotope_item = '';
    $is_carousel = 'gg-slick-carousel';
    $convert_ul = 'div';
    $convert_li = 'div';
    $portfolio_columns_class ='';
    $portfolio_no_posts = '-1';
    $portfolio_pagination = 'none';
    $carousel_autoplay = 'no';

    $carousel_data = '';
    //$carousel_data .= ' "slidesToShow": 1, ';
    $carousel_data .= ' "arrows": true, ';
    $carousel_data .= ' "dots": false, ';
    $carousel_data .= ' "autoplay": '.($carousel_autoplay == 'yes' ? 'true' : 'false').', ';
    $carousel_data .= ' "infinite": true, ';
    $carousel_data .= ' "variableWidth": true, ';
    //$carousel_data .= ' "centerMode": true, ';
    //$carousel_data .= ' "centerPadding": "25%", ';
    $carousel_data .= ' "adaptiveHeight": true, ';
    if (is_rtl()) {
       $carousel_data .= ' "rtl": true, '; 
    }
    $carousel_data .= ' "slidesToScroll": 1 ';

    $carousel_data_html = ' data-mousewheel="true" data-slick=\'{ '.$carousel_data.' }\' ';
} else {
    $isotope_item = 'isotope-item';
    $is_carousel = $carousel_data_html = '';
}
?>

<section id="content">
    <div class="<?php echo esc_attr($page_container_class); ?>">
        
        <?php if ( $page_layout == 'no_sidebar' ) : ?> 
        <div class="gg-content-separator"></div>
        <?php endif; //Apply full width border ?>

        <div class="row">
            <div class="<?php echo esc_attr($page_content_class); ?>">

                <?php if ( $page_layout != 'no_sidebar' ) : ?> 
                <div class="gg-content-separator"></div>
                <?php endif; //Apply content border ?>

                <!-- Begin portfolio posts -->
                <?php
                    //Load magnific 
                    wp_enqueue_script('magnific');
                    wp_enqueue_style('magnific');

                    $paged = get_query_var('paged') ? get_query_var('paged') : 1;

                    // WP_Query arguments
                    $args = array (
                        'post_type'              => 'portfolio_cpt',
                        'portfolio_category'     => $term_slug,
                        'taxonomy'               => 'portfolio_category',
                        'posts_per_page'         => $portfolio_no_posts, 
                        'ignore_sticky_posts'    => true,
                        'paged'                  => $paged,
                    );

                    // The Query
                    $portfolio_query = new WP_Query( $args );

                    // The Loop
                    if ( $portfolio_query->have_posts() ) { ?>
                    <!-- Verify row class for isotope -->
                    <div class="gg_posts_grid">

                    <?php if (($portfolio_cat_filter == '1') && (empty($terms))) { ?>    
                    <ul class="categories_filter clearfix nav nav-pills">
                        <li class="active"><a href="#" data-filter="*"><?php echo esc_attr__("All", "okthemes"); ?></a></li>

                        <?php
                        $terms = get_terms('portfolio_category');
                        foreach ( $terms as $term ) {
                            echo '<li><a data-filter=".grid-cat-'.esc_attr($term->slug).'">' . esc_attr($term->name) . ' </a></li>';
                        }
                        ?>
                    </ul>
                    <?php } ?>

                    <ul id="da-thumbs" <?php echo $carousel_data_html; ?> class="el-grid da-thumbs <?php echo esc_attr($is_carousel); ?> <?php if($portfolio_layout_style == 'nogap') echo 'nogap-cols'; ?>" data-layout-mode="<?php echo esc_attr($portfolio_layout); ?>" data-gap="<?php echo esc_attr($portfolio_layout_style); ?>" data-pagination="<?php echo esc_attr($portfolio_pagination); ?>" >

                        <?php while ( $portfolio_query->have_posts() ) : $portfolio_query->the_post(); ?>

                            <li class="<?php echo esc_attr($portfolio_columns_class); ?> <?php echo esc_attr($isotope_item); ?> <?php echo esc_attr(gg_tax_terms_slug('portfolio_category')); ?>" >
                                <?php 
                                if ($portfolio_layout == 'carousel' ) {
                                    get_template_part( 'parts/part','portfolio-carousel' );
                                } else {
                                    get_template_part( 'parts/part','portfolio' );
                                }
                                ?>
                            </li><!-- // portfolio item column -->

                        <?php endwhile; ?>
                    </ul>
                    </div>    

                    <?php } else { ?>

                        <div class="no-posts-created"> 
                            <h3><?php _e( 'Not Found', 'okthemes' ); ?></h3>  
                            <p><?php _e( 'Sorry, No portfolio posts created yet.', 'okthemes' ); ?></p>  
                        </div>
                        
                    <?php } ?>

                    <?php 
                    if ($portfolio_pagination == 'ajax_load') { ?>
                        <div class="load-more-anim"></div>
                        <div class="pagination-load-more">
                            <span class="pagination-span">
                            <?php next_posts_link('Load more posts', $portfolio_query->max_num_pages) ?>
                            </span>
                        </div>

                    <?php } else {
                        
                        if (function_exists("gg_pagination")) {
                            gg_pagination($portfolio_query->max_num_pages);
                        }
                    } ?>

                    <?php 
                    // Restore original Post Data    
                    wp_reset_postdata();
                    ?> 

                </div><!-- /.col-8 col-sm-8 col-lg-8 -->

                <?php if (($page_layout !== 'no_sidebar')) { ?>
                <div class="<?php echo esc_attr($page_sidebar_class); if ( $page_layout != 'no_sidebar' ) echo ' gg-sidebar-move-up'; ?>">
                    <aside class="sidebar-nav">
                        <?php get_sidebar(); ?>
                    </aside>
                    <!--/aside .sidebar-nav -->
                </div><!-- /.col-4 col-sm-4 col-lg-4 -->
                <?php } ?>

        </div>
    </div>    
</section>

<?php get_footer(); ?>