<?php
/**
 * Add to wishlist button template
 *
 * @author Your Inspiration Themes
 * @package YITH WooCommerce Wishlist
 * @version 2.0.0
 */

global $product;
?>

<a href="<?php echo esc_url( add_query_arg( 'add_to_wishlist', $product_id ) )?>" rel="nofollow" data-product-id="<?php echo esc_attr( $product_id ); ?>" data-product-type="<?php echo esc_attr( $product_type ); ?>" class="<?php echo esc_attr( $link_classes ); ?>" >
    <i class="pe-7s-like"></i>
    
    <?php
    	if ( is_woocommerce_activated() && is_product() ) {
    		echo '<span>' . $label . '</span>';
    	}
    ?>

</a>

<img src="<?php echo esc_url( get_template_directory_uri() .'/images/animated-ring.gif' ); ?>" class="ajax-loading" alt="loading" style="visibility:hidden; position:absolute; left:0;" />