<?php
/**
 * Loop Add to Cart
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/loop/add-to-cart.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see 	    https://docs.woocommerce.com/document/template-structure/
 * @author 		WooThemes
 * @package 	WooCommerce/Templates
 * @version     3.0.0
 */

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

global $product, $yith_wcwl;
?>

<div class="product-buttons-icns">

		<?php if ( 1 != get_theme_mod('store_catalog_mode', 1) ) : ?>
		<?php
		echo apply_filters( 'woocommerce_loop_add_to_cart_link',
			sprintf( '<a rel="nofollow" href="%s" data-quantity="%s" data-product_id="%s" data-product_sku="%s" class="%s add_to_cart_button product-icn"><i class="pe-7s-cart"></i></a>',
				esc_url( $product->add_to_cart_url() ),
				esc_attr( isset( $quantity ) ? $quantity : 1 ),
				esc_attr( $product->get_id() ),
				esc_attr( $product->get_sku() ),
				esc_attr( isset( $class ) ? $class : ' button ' )
				//esc_html( $product->add_to_cart_text())
			),
		$product );

		?>
		<?php endif; ?>

	<?php
		if ( class_exists( 'YITH_WCWL_Init' ) ) { 
			if ( get_theme_mod('store_add_to_wishlist', 1 ) ) { 
				echo do_shortcode( '[yith_wcwl_add_to_wishlist]' );
			}
		}
	?>

	<?php if ( !get_theme_mod('store_catalog_mode')) : ?>
	<span class="product-icn link-to-product">
		<a href="<?php the_permalink(); ?>">
			<i class="pe-7s-link"></i>
		</a>
	</span>
	<?php endif; ?>

</div>
