<?php
/**
 * The template for displaying product search form
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/product-searchform.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you (the theme developer).
 * will need to copy the new files to your theme to maintain compatibility. We try to do this.
 * as little as possible, but it does happen. When this occurs the version of the template file will.
 * be bumped and the readme will list any important changes.
 *
 * @see     http://docs.woothemes.com/document/template-structure/
 * @author  WooThemes
 * @package WooCommerce/Templates
 * @version 2.5.0
 */

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

?>

<form role="search" method="get" id="searchform" class="" action="<?php echo esc_url( home_url( '/' ) ); ?>">
	<div class="input-group">
		<span class="input-group-addon"><i class="icon_search"></i></span>
		<input class="form-control" type="text" value="<?php the_search_query(); ?>" placeholder="<?php esc_attr_e( 'Search', 'okthemes' ); ?>" name="s" id="s" />
		<span class="input-group-btn">
			<input class="btn btn-primary" type="submit" name="submit" id="searchsubmit" value="<?php esc_attr_e( 'Search', 'okthemes' ); ?>" />
		</span>
		<input type="hidden" name="post_type" value="product" />
	</div>
</form>